// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.StoragePool
{
    internal class DiskPoolIscsiTargetOperationSource : IOperationSource<DiskPoolIscsiTargetResource>
    {
        private readonly ArmClient _client;

        internal DiskPoolIscsiTargetOperationSource(ArmClient client)
        {
            _client = client;
        }

        DiskPoolIscsiTargetResource IOperationSource<DiskPoolIscsiTargetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DiskPoolIscsiTargetData.DeserializeDiskPoolIscsiTargetData(document.RootElement);
            return new DiskPoolIscsiTargetResource(_client, data);
        }

        async ValueTask<DiskPoolIscsiTargetResource> IOperationSource<DiskPoolIscsiTargetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DiskPoolIscsiTargetData.DeserializeDiskPoolIscsiTargetData(document.RootElement);
            return new DiskPoolIscsiTargetResource(_client, data);
        }
    }
}
