// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.StorageMover.Models;

namespace Azure.ResourceManager.StorageMover
{
    public partial class StorageMoverAgentData : IUtf8JsonSerializable, IJsonModel<StorageMoverAgentData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageMoverAgentData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageMoverAgentData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageMoverAgentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageMoverAgentData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(AgentVersion))
            {
                writer.WritePropertyName("agentVersion"u8);
                writer.WriteStringValue(AgentVersion);
            }
            writer.WritePropertyName("arcResourceId"u8);
            writer.WriteStringValue(ArcResourceId);
            writer.WritePropertyName("arcVmUuid"u8);
            writer.WriteStringValue(ArcVmUuid);
            if (options.Format != "W" && Optional.IsDefined(AgentStatus))
            {
                writer.WritePropertyName("agentStatus"u8);
                writer.WriteStringValue(AgentStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LastStatusUpdate))
            {
                writer.WritePropertyName("lastStatusUpdate"u8);
                writer.WriteStringValue(LastStatusUpdate.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LocalIPAddress))
            {
                writer.WritePropertyName("localIPAddress"u8);
                writer.WriteStringValue(LocalIPAddress);
            }
            if (options.Format != "W" && Optional.IsDefined(MemoryInMB))
            {
                writer.WritePropertyName("memoryInMB"u8);
                writer.WriteNumberValue(MemoryInMB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NumberOfCores))
            {
                writer.WritePropertyName("numberOfCores"u8);
                writer.WriteNumberValue(NumberOfCores.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UptimeInSeconds))
            {
                writer.WritePropertyName("uptimeInSeconds"u8);
                writer.WriteNumberValue(UptimeInSeconds.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TimeZone))
            {
                writer.WritePropertyName("timeZone"u8);
                writer.WriteStringValue(TimeZone);
            }
            if (Optional.IsDefined(UploadLimitSchedule))
            {
                writer.WritePropertyName("uploadLimitSchedule"u8);
                writer.WriteObjectValue(UploadLimitSchedule, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorDetails))
            {
                writer.WritePropertyName("errorDetails"u8);
                writer.WriteObjectValue(ErrorDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        StorageMoverAgentData IJsonModel<StorageMoverAgentData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageMoverAgentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageMoverAgentData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageMoverAgentData(document.RootElement, options);
        }

        internal static StorageMoverAgentData DeserializeStorageMoverAgentData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            string agentVersion = default;
            string arcResourceId = default;
            string arcVmUuid = default;
            StorageMoverAgentStatus? agentStatus = default;
            DateTimeOffset? lastStatusUpdate = default;
            string localIPAddress = default;
            long? memoryInMB = default;
            long? numberOfCores = default;
            long? uptimeInSeconds = default;
            string timeZone = default;
            UploadLimitSchedule uploadLimitSchedule = default;
            StorageMoverAgentPropertiesErrorDetails errorDetails = default;
            StorageMoverProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("agentVersion"u8))
                        {
                            agentVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("arcResourceId"u8))
                        {
                            arcResourceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("arcVmUuid"u8))
                        {
                            arcVmUuid = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("agentStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            agentStatus = new StorageMoverAgentStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("lastStatusUpdate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastStatusUpdate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("localIPAddress"u8))
                        {
                            localIPAddress = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("memoryInMB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            memoryInMB = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("numberOfCores"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            numberOfCores = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("uptimeInSeconds"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            uptimeInSeconds = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("timeZone"u8))
                        {
                            timeZone = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("uploadLimitSchedule"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            uploadLimitSchedule = UploadLimitSchedule.DeserializeUploadLimitSchedule(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("errorDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            errorDetails = StorageMoverAgentPropertiesErrorDetails.DeserializeStorageMoverAgentPropertiesErrorDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new StorageMoverProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageMoverAgentData(
                id,
                name,
                type,
                systemData,
                description,
                agentVersion,
                arcResourceId,
                arcVmUuid,
                agentStatus,
                lastStatusUpdate,
                localIPAddress,
                memoryInMB,
                numberOfCores,
                uptimeInSeconds,
                timeZone,
                uploadLimitSchedule,
                errorDetails,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageMoverAgentData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageMoverAgentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageMoverAgentData)} does not support writing '{options.Format}' format.");
            }
        }

        StorageMoverAgentData IPersistableModel<StorageMoverAgentData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageMoverAgentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageMoverAgentData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageMoverAgentData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageMoverAgentData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
