// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The provisioning state of a resource. </summary>
    public readonly partial struct StorageMoverProvisioningState : IEquatable<StorageMoverProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageMoverProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageMoverProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string DeletingValue = "Deleting";

        /// <summary> Succeeded. </summary>
        public static StorageMoverProvisioningState Succeeded { get; } = new StorageMoverProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static StorageMoverProvisioningState Canceled { get; } = new StorageMoverProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static StorageMoverProvisioningState Failed { get; } = new StorageMoverProvisioningState(FailedValue);
        /// <summary> Deleting. </summary>
        public static StorageMoverProvisioningState Deleting { get; } = new StorageMoverProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="StorageMoverProvisioningState"/> values are the same. </summary>
        public static bool operator ==(StorageMoverProvisioningState left, StorageMoverProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageMoverProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(StorageMoverProvisioningState left, StorageMoverProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageMoverProvisioningState"/>. </summary>
        public static implicit operator StorageMoverProvisioningState(string value) => new StorageMoverProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageMoverProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageMoverProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
