// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> Strategy to use for copy. </summary>
    public readonly partial struct StorageMoverCopyMode : IEquatable<StorageMoverCopyMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageMoverCopyMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageMoverCopyMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdditiveValue = "Additive";
        private const string MirrorValue = "Mirror";

        /// <summary> Additive. </summary>
        public static StorageMoverCopyMode Additive { get; } = new StorageMoverCopyMode(AdditiveValue);
        /// <summary> Mirror. </summary>
        public static StorageMoverCopyMode Mirror { get; } = new StorageMoverCopyMode(MirrorValue);
        /// <summary> Determines if two <see cref="StorageMoverCopyMode"/> values are the same. </summary>
        public static bool operator ==(StorageMoverCopyMode left, StorageMoverCopyMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageMoverCopyMode"/> values are not the same. </summary>
        public static bool operator !=(StorageMoverCopyMode left, StorageMoverCopyMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageMoverCopyMode"/>. </summary>
        public static implicit operator StorageMoverCopyMode(string value) => new StorageMoverCopyMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageMoverCopyMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageMoverCopyMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
