// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The Agent status. </summary>
    public readonly partial struct StorageMoverAgentStatus : IEquatable<StorageMoverAgentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageMoverAgentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageMoverAgentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteringValue = "Registering";
        private const string OfflineValue = "Offline";
        private const string OnlineValue = "Online";
        private const string ExecutingValue = "Executing";
        private const string RequiresAttentionValue = "RequiresAttention";
        private const string UnregisteringValue = "Unregistering";

        /// <summary> Registering. </summary>
        public static StorageMoverAgentStatus Registering { get; } = new StorageMoverAgentStatus(RegisteringValue);
        /// <summary> Offline. </summary>
        public static StorageMoverAgentStatus Offline { get; } = new StorageMoverAgentStatus(OfflineValue);
        /// <summary> Online. </summary>
        public static StorageMoverAgentStatus Online { get; } = new StorageMoverAgentStatus(OnlineValue);
        /// <summary> Executing. </summary>
        public static StorageMoverAgentStatus Executing { get; } = new StorageMoverAgentStatus(ExecutingValue);
        /// <summary> RequiresAttention. </summary>
        public static StorageMoverAgentStatus RequiresAttention { get; } = new StorageMoverAgentStatus(RequiresAttentionValue);
        /// <summary> Unregistering. </summary>
        public static StorageMoverAgentStatus Unregistering { get; } = new StorageMoverAgentStatus(UnregisteringValue);
        /// <summary> Determines if two <see cref="StorageMoverAgentStatus"/> values are the same. </summary>
        public static bool operator ==(StorageMoverAgentStatus left, StorageMoverAgentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageMoverAgentStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageMoverAgentStatus left, StorageMoverAgentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageMoverAgentStatus"/>. </summary>
        public static implicit operator StorageMoverAgentStatus(string value) => new StorageMoverAgentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageMoverAgentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageMoverAgentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
