// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The minute element of the time. Allowed values are 0 and 30. If not specified, its value defaults to 0. </summary>
    public readonly partial struct ScheduleMinute : IEquatable<ScheduleMinute>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="ScheduleMinute"/>. </summary>
        public ScheduleMinute(int value)
        {
            _value = value;
        }

        private const int ZeroValue = 0;
        private const int ThirtyValue = 30;

        /// <summary> 0. </summary>
        public static ScheduleMinute Zero { get; } = new ScheduleMinute(ZeroValue);
        /// <summary> 30. </summary>
        public static ScheduleMinute Thirty { get; } = new ScheduleMinute(ThirtyValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="ScheduleMinute"/> values are the same. </summary>
        public static bool operator ==(ScheduleMinute left, ScheduleMinute right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduleMinute"/> values are not the same. </summary>
        public static bool operator !=(ScheduleMinute left, ScheduleMinute right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="ScheduleMinute"/>. </summary>
        public static implicit operator ScheduleMinute(int value) => new ScheduleMinute(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduleMinute other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduleMinute other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
