// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The status of Agent's scanning of source. </summary>
    public readonly partial struct JobRunScanStatus : IEquatable<JobRunScanStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="JobRunScanStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public JobRunScanStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string ScanningValue = "Scanning";
        private const string CompletedValue = "Completed";

        /// <summary> NotStarted. </summary>
        public static JobRunScanStatus NotStarted { get; } = new JobRunScanStatus(NotStartedValue);
        /// <summary> Scanning. </summary>
        public static JobRunScanStatus Scanning { get; } = new JobRunScanStatus(ScanningValue);
        /// <summary> Completed. </summary>
        public static JobRunScanStatus Completed { get; } = new JobRunScanStatus(CompletedValue);
        /// <summary> Determines if two <see cref="JobRunScanStatus"/> values are the same. </summary>
        public static bool operator ==(JobRunScanStatus left, JobRunScanStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="JobRunScanStatus"/> values are not the same. </summary>
        public static bool operator !=(JobRunScanStatus left, JobRunScanStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="JobRunScanStatus"/>. </summary>
        public static implicit operator JobRunScanStatus(string value) => new JobRunScanStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is JobRunScanStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(JobRunScanStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
