// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The Endpoint resource type. </summary>
    internal readonly partial struct EndpointType : IEquatable<EndpointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EndpointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EndpointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureStorageBlobContainerValue = "AzureStorageBlobContainer";
        private const string NfsMountValue = "NfsMount";
        private const string AzureStorageSmbFileShareValue = "AzureStorageSmbFileShare";
        private const string SmbMountValue = "SmbMount";

        /// <summary> AzureStorageBlobContainer. </summary>
        public static EndpointType AzureStorageBlobContainer { get; } = new EndpointType(AzureStorageBlobContainerValue);
        /// <summary> NfsMount. </summary>
        public static EndpointType NfsMount { get; } = new EndpointType(NfsMountValue);
        /// <summary> AzureStorageSmbFileShare. </summary>
        public static EndpointType AzureStorageSmbFileShare { get; } = new EndpointType(AzureStorageSmbFileShareValue);
        /// <summary> SmbMount. </summary>
        public static EndpointType SmbMount { get; } = new EndpointType(SmbMountValue);
        /// <summary> Determines if two <see cref="EndpointType"/> values are the same. </summary>
        public static bool operator ==(EndpointType left, EndpointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EndpointType"/> values are not the same. </summary>
        public static bool operator !=(EndpointType left, EndpointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EndpointType"/>. </summary>
        public static implicit operator EndpointType(string value) => new EndpointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EndpointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EndpointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
