// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageMover.Models
{
    /// <summary> The properties of Azure Storage blob container endpoint. </summary>
    public partial class AzureStorageBlobContainerEndpointProperties : EndpointBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AzureStorageBlobContainerEndpointProperties"/>. </summary>
        /// <param name="storageAccountResourceId"> The Azure Resource ID of the storage account that is the target destination. </param>
        /// <param name="blobContainerName"> The name of the Storage blob container that is the target destination. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageAccountResourceId"/> or <paramref name="blobContainerName"/> is null. </exception>
        public AzureStorageBlobContainerEndpointProperties(string storageAccountResourceId, string blobContainerName)
        {
            Argument.AssertNotNull(storageAccountResourceId, nameof(storageAccountResourceId));
            Argument.AssertNotNull(blobContainerName, nameof(blobContainerName));

            StorageAccountResourceId = storageAccountResourceId;
            BlobContainerName = blobContainerName;
            EndpointType = EndpointType.AzureStorageBlobContainer;
        }

        /// <summary> Initializes a new instance of <see cref="AzureStorageBlobContainerEndpointProperties"/>. </summary>
        /// <param name="endpointType"> The Endpoint resource type. </param>
        /// <param name="description"> A description for the Endpoint. </param>
        /// <param name="provisioningState"> The provisioning state of this resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="storageAccountResourceId"> The Azure Resource ID of the storage account that is the target destination. </param>
        /// <param name="blobContainerName"> The name of the Storage blob container that is the target destination. </param>
        internal AzureStorageBlobContainerEndpointProperties(EndpointType endpointType, string description, StorageMoverProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData, string storageAccountResourceId, string blobContainerName) : base(endpointType, description, provisioningState, serializedAdditionalRawData)
        {
            StorageAccountResourceId = storageAccountResourceId;
            BlobContainerName = blobContainerName;
            EndpointType = endpointType;
        }

        /// <summary> Initializes a new instance of <see cref="AzureStorageBlobContainerEndpointProperties"/> for deserialization. </summary>
        internal AzureStorageBlobContainerEndpointProperties()
        {
        }

        /// <summary> The Azure Resource ID of the storage account that is the target destination. </summary>
        public string StorageAccountResourceId { get; set; }
        /// <summary> The name of the Storage blob container that is the target destination. </summary>
        public string BlobContainerName { get; set; }
    }
}
