// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageMover.Models
{
    public partial class AzureKeyVaultSmbCredentials : IUtf8JsonSerializable, IJsonModel<AzureKeyVaultSmbCredentials>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AzureKeyVaultSmbCredentials>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AzureKeyVaultSmbCredentials>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AzureKeyVaultSmbCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AzureKeyVaultSmbCredentials)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(UsernameUriString))
            {
                writer.WritePropertyName("usernameUri"u8);
                writer.WriteStringValue(UsernameUriString);
            }
            if (Optional.IsDefined(PasswordUriString))
            {
                writer.WritePropertyName("passwordUri"u8);
                writer.WriteStringValue(PasswordUriString);
            }
        }

        AzureKeyVaultSmbCredentials IJsonModel<AzureKeyVaultSmbCredentials>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AzureKeyVaultSmbCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AzureKeyVaultSmbCredentials)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAzureKeyVaultSmbCredentials(document.RootElement, options);
        }

        internal static AzureKeyVaultSmbCredentials DeserializeAzureKeyVaultSmbCredentials(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string usernameUriString = default;
            string passwordUriString = default;
            CredentialType type = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("usernameUri"u8))
                {
                    usernameUriString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("passwordUri"u8))
                {
                    passwordUriString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new CredentialType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AzureKeyVaultSmbCredentials(type, serializedAdditionalRawData, usernameUriString, passwordUriString);
        }

        BinaryData IPersistableModel<AzureKeyVaultSmbCredentials>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AzureKeyVaultSmbCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AzureKeyVaultSmbCredentials)} does not support writing '{options.Format}' format.");
            }
        }

        AzureKeyVaultSmbCredentials IPersistableModel<AzureKeyVaultSmbCredentials>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AzureKeyVaultSmbCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAzureKeyVaultSmbCredentials(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AzureKeyVaultSmbCredentials)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AzureKeyVaultSmbCredentials>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
