// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.StorageCache.Models;

namespace Azure.ResourceManager.StorageCache
{
    public partial class StorageTargetData : IUtf8JsonSerializable, IJsonModel<StorageTargetData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageTargetData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageTargetData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTargetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTargetData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Junctions))
            {
                writer.WritePropertyName("junctions"u8);
                writer.WriteStartArray();
                foreach (var item in Junctions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(TargetType))
            {
                writer.WritePropertyName("targetType"u8);
                writer.WriteStringValue(TargetType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(Nfs3))
            {
                writer.WritePropertyName("nfs3"u8);
                writer.WriteObjectValue(Nfs3, options);
            }
            if (Optional.IsDefined(Clfs))
            {
                writer.WritePropertyName("clfs"u8);
                writer.WriteObjectValue(Clfs, options);
            }
            if (Optional.IsDefined(Unknown))
            {
                writer.WritePropertyName("unknown"u8);
                writer.WriteObjectValue(Unknown, options);
            }
            if (Optional.IsDefined(BlobNfs))
            {
                writer.WritePropertyName("blobNfs"u8);
                writer.WriteObjectValue(BlobNfs, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AllocationPercentage))
            {
                writer.WritePropertyName("allocationPercentage"u8);
                writer.WriteNumberValue(AllocationPercentage.Value);
            }
            writer.WriteEndObject();
        }

        StorageTargetData IJsonModel<StorageTargetData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTargetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTargetData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageTargetData(document.RootElement, options);
        }

        internal static StorageTargetData DeserializeStorageTargetData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IList<NamespaceJunction> junctions = default;
            StorageTargetType? targetType = default;
            StorageCacheProvisioningStateType? provisioningState = default;
            StorageTargetOperationalStateType? state = default;
            Nfs3Target nfs3 = default;
            ClfsTarget clfs = default;
            UnknownTarget unknown = default;
            BlobNfsTarget blobNfs = default;
            int? allocationPercentage = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("junctions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<NamespaceJunction> array = new List<NamespaceJunction>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(NamespaceJunction.DeserializeNamespaceJunction(item, options));
                            }
                            junctions = array;
                            continue;
                        }
                        if (property0.NameEquals("targetType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            targetType = new StorageTargetType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new StorageCacheProvisioningStateType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new StorageTargetOperationalStateType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("nfs3"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            nfs3 = Nfs3Target.DeserializeNfs3Target(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("clfs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clfs = Models.ClfsTarget.DeserializeClfsTarget(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("unknown"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            unknown = UnknownTarget.DeserializeUnknownTarget(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("blobNfs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            blobNfs = BlobNfsTarget.DeserializeBlobNfsTarget(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("allocationPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            allocationPercentage = property0.Value.GetInt32();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageTargetData(
                id,
                name,
                type,
                systemData,
                junctions ?? new ChangeTrackingList<NamespaceJunction>(),
                targetType,
                provisioningState,
                state,
                nfs3,
                clfs,
                unknown,
                blobNfs,
                allocationPercentage,
                location,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageTargetData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTargetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageTargetData)} does not support writing '{options.Format}' format.");
            }
        }

        StorageTargetData IPersistableModel<StorageTargetData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTargetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageTargetData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageTargetData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageTargetData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
