// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.StorageCache.Models;

namespace Azure.ResourceManager.StorageCache
{
    public partial class StorageCacheImportJobData : IUtf8JsonSerializable, IJsonModel<StorageCacheImportJobData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageCacheImportJobData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageCacheImportJobData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheImportJobData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheImportJobData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ImportPrefixes))
            {
                writer.WritePropertyName("importPrefixes"u8);
                writer.WriteStartArray();
                foreach (var item in ImportPrefixes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ConflictResolutionMode))
            {
                writer.WritePropertyName("conflictResolutionMode"u8);
                writer.WriteStringValue(ConflictResolutionMode.Value.ToString());
            }
            if (Optional.IsDefined(MaximumErrors))
            {
                writer.WritePropertyName("maximumErrors"u8);
                writer.WriteNumberValue(MaximumErrors.Value);
            }
            writer.WritePropertyName("status"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StatusMessage))
            {
                writer.WritePropertyName("statusMessage"u8);
                writer.WriteStringValue(StatusMessage);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalBlobsWalked))
            {
                writer.WritePropertyName("totalBlobsWalked"u8);
                writer.WriteNumberValue(TotalBlobsWalked.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BlobsWalkedPerSecond))
            {
                writer.WritePropertyName("blobsWalkedPerSecond"u8);
                writer.WriteNumberValue(BlobsWalkedPerSecond.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalBlobsImported))
            {
                writer.WritePropertyName("totalBlobsImported"u8);
                writer.WriteNumberValue(TotalBlobsImported.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BlobsImportedPerSecond))
            {
                writer.WritePropertyName("blobsImportedPerSecond"u8);
                writer.WriteNumberValue(BlobsImportedPerSecond.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LastCompletionOn))
            {
                writer.WritePropertyName("lastCompletionTime"u8);
                writer.WriteStringValue(LastCompletionOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastStartedOn))
            {
                writer.WritePropertyName("lastStartedTime"u8);
                writer.WriteStringValue(LastStartedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TotalErrors))
            {
                writer.WritePropertyName("totalErrors"u8);
                writer.WriteNumberValue(TotalErrors.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalConflicts))
            {
                writer.WritePropertyName("totalConflicts"u8);
                writer.WriteNumberValue(TotalConflicts.Value);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        StorageCacheImportJobData IJsonModel<StorageCacheImportJobData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheImportJobData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheImportJobData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageCacheImportJobData(document.RootElement, options);
        }

        internal static StorageCacheImportJobData DeserializeStorageCacheImportJobData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ImportJobProvisioningStateType? provisioningState = default;
            IList<string> importPrefixes = default;
            ConflictResolutionMode? conflictResolutionMode = default;
            int? maximumErrors = default;
            ImportStatusType? state = default;
            string statusMessage = default;
            long? totalBlobsWalked = default;
            long? blobsWalkedPerSecond = default;
            long? totalBlobsImported = default;
            long? blobsImportedPerSecond = default;
            DateTimeOffset? lastCompletionTime = default;
            DateTimeOffset? lastStartedTime = default;
            int? totalErrors = default;
            int? totalConflicts = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ImportJobProvisioningStateType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("importPrefixes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            importPrefixes = array;
                            continue;
                        }
                        if (property0.NameEquals("conflictResolutionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            conflictResolutionMode = new ConflictResolutionMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("maximumErrors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maximumErrors = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("state"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    state = new ImportStatusType(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("statusMessage"u8))
                                {
                                    statusMessage = property1.Value.GetString();
                                    continue;
                                }
                                if (property1.NameEquals("totalBlobsWalked"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    totalBlobsWalked = property1.Value.GetInt64();
                                    continue;
                                }
                                if (property1.NameEquals("blobsWalkedPerSecond"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    blobsWalkedPerSecond = property1.Value.GetInt64();
                                    continue;
                                }
                                if (property1.NameEquals("totalBlobsImported"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    totalBlobsImported = property1.Value.GetInt64();
                                    continue;
                                }
                                if (property1.NameEquals("blobsImportedPerSecond"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    blobsImportedPerSecond = property1.Value.GetInt64();
                                    continue;
                                }
                                if (property1.NameEquals("lastCompletionTime"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    lastCompletionTime = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("lastStartedTime"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    lastStartedTime = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("totalErrors"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    totalErrors = property1.Value.GetInt32();
                                    continue;
                                }
                                if (property1.NameEquals("totalConflicts"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    totalConflicts = property1.Value.GetInt32();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageCacheImportJobData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                provisioningState,
                importPrefixes ?? new ChangeTrackingList<string>(),
                conflictResolutionMode,
                maximumErrors,
                state,
                statusMessage,
                totalBlobsWalked,
                blobsWalkedPerSecond,
                totalBlobsImported,
                blobsImportedPerSecond,
                lastCompletionTime,
                lastStartedTime,
                totalErrors,
                totalConflicts,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageCacheImportJobData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheImportJobData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageCacheImportJobData)} does not support writing '{options.Format}' format.");
            }
        }

        StorageCacheImportJobData IPersistableModel<StorageCacheImportJobData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheImportJobData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageCacheImportJobData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageCacheImportJobData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageCacheImportJobData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
