// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.StorageCache
{
    /// <summary>
    /// A class representing a collection of <see cref="StorageCacheImportJobResource"/> and their operations.
    /// Each <see cref="StorageCacheImportJobResource"/> in the collection will belong to the same instance of <see cref="AmlFileSystemResource"/>.
    /// To get a <see cref="StorageCacheImportJobCollection"/> instance call the GetStorageCacheImportJobs method from an instance of <see cref="AmlFileSystemResource"/>.
    /// </summary>
    public partial class StorageCacheImportJobCollection : ArmCollection, IEnumerable<StorageCacheImportJobResource>, IAsyncEnumerable<StorageCacheImportJobResource>
    {
        private readonly ClientDiagnostics _storageCacheImportJobimportJobsClientDiagnostics;
        private readonly ImportJobsRestOperations _storageCacheImportJobimportJobsRestClient;

        /// <summary> Initializes a new instance of the <see cref="StorageCacheImportJobCollection"/> class for mocking. </summary>
        protected StorageCacheImportJobCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="StorageCacheImportJobCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal StorageCacheImportJobCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _storageCacheImportJobimportJobsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.StorageCache", StorageCacheImportJobResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(StorageCacheImportJobResource.ResourceType, out string storageCacheImportJobimportJobsApiVersion);
            _storageCacheImportJobimportJobsRestClient = new ImportJobsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, storageCacheImportJobimportJobsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AmlFileSystemResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AmlFileSystemResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update an import job. Import jobs are automatically deleted 72 hours after completion.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="data"> Object containing the user-selectable properties of the import job. If read-only properties are included, they must match the existing values of those properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<StorageCacheImportJobResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string importJobName, StorageCacheImportJobData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _storageCacheImportJobimportJobsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, data, cancellationToken).ConfigureAwait(false);
                var operation = new StorageCacheArmOperation<StorageCacheImportJobResource>(new StorageCacheImportJobOperationSource(Client), _storageCacheImportJobimportJobsClientDiagnostics, Pipeline, _storageCacheImportJobimportJobsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update an import job. Import jobs are automatically deleted 72 hours after completion.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="data"> Object containing the user-selectable properties of the import job. If read-only properties are included, they must match the existing values of those properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<StorageCacheImportJobResource> CreateOrUpdate(WaitUntil waitUntil, string importJobName, StorageCacheImportJobData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _storageCacheImportJobimportJobsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, data, cancellationToken);
                var operation = new StorageCacheArmOperation<StorageCacheImportJobResource>(new StorageCacheImportJobOperationSource(Client), _storageCacheImportJobimportJobsClientDiagnostics, Pipeline, _storageCacheImportJobimportJobsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns an import job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual async Task<Response<StorageCacheImportJobResource>> GetAsync(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.Get");
            scope.Start();
            try
            {
                var response = await _storageCacheImportJobimportJobsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StorageCacheImportJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns an import job.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual Response<StorageCacheImportJobResource> Get(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.Get");
            scope.Start();
            try
            {
                var response = _storageCacheImportJobimportJobsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StorageCacheImportJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns all import jobs the user has access to under an AML File System.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_ListByAmlFileSystem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="StorageCacheImportJobResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<StorageCacheImportJobResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _storageCacheImportJobimportJobsRestClient.CreateListByAmlFileSystemRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _storageCacheImportJobimportJobsRestClient.CreateListByAmlFileSystemNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new StorageCacheImportJobResource(Client, StorageCacheImportJobData.DeserializeStorageCacheImportJobData(e)), _storageCacheImportJobimportJobsClientDiagnostics, Pipeline, "StorageCacheImportJobCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns all import jobs the user has access to under an AML File System.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_ListByAmlFileSystem</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="StorageCacheImportJobResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<StorageCacheImportJobResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _storageCacheImportJobimportJobsRestClient.CreateListByAmlFileSystemRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _storageCacheImportJobimportJobsRestClient.CreateListByAmlFileSystemNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new StorageCacheImportJobResource(Client, StorageCacheImportJobData.DeserializeStorageCacheImportJobData(e)), _storageCacheImportJobimportJobsClientDiagnostics, Pipeline, "StorageCacheImportJobCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.Exists");
            scope.Start();
            try
            {
                var response = await _storageCacheImportJobimportJobsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual Response<bool> Exists(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.Exists");
            scope.Start();
            try
            {
                var response = _storageCacheImportJobimportJobsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual async Task<NullableResponse<StorageCacheImportJobResource>> GetIfExistsAsync(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _storageCacheImportJobimportJobsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<StorageCacheImportJobResource>(response.GetRawResponse());
                return Response.FromValue(new StorageCacheImportJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>importJobs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageCacheImportJobResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="importJobName"> Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="importJobName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="importJobName"/> is null. </exception>
        public virtual NullableResponse<StorageCacheImportJobResource> GetIfExists(string importJobName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(importJobName, nameof(importJobName));

            using var scope = _storageCacheImportJobimportJobsClientDiagnostics.CreateScope("StorageCacheImportJobCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _storageCacheImportJobimportJobsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, importJobName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<StorageCacheImportJobResource>(response.GetRawResponse());
                return Response.FromValue(new StorageCacheImportJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<StorageCacheImportJobResource> IEnumerable<StorageCacheImportJobResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<StorageCacheImportJobResource> IAsyncEnumerable<StorageCacheImportJobResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
