// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Type of the Storage Target. </summary>
    public readonly partial struct StorageTargetType : IEquatable<StorageTargetType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTargetType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTargetType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Nfs3Value = "nfs3";
        private const string ClfsValue = "clfs";
        private const string UnknownValue = "unknown";
        private const string BlobNfsValue = "blobNfs";

        /// <summary> nfs3. </summary>
        public static StorageTargetType Nfs3 { get; } = new StorageTargetType(Nfs3Value);
        /// <summary> clfs. </summary>
        public static StorageTargetType Clfs { get; } = new StorageTargetType(ClfsValue);
        /// <summary> unknown. </summary>
        public static StorageTargetType Unknown { get; } = new StorageTargetType(UnknownValue);
        /// <summary> blobNfs. </summary>
        public static StorageTargetType BlobNfs { get; } = new StorageTargetType(BlobNfsValue);
        /// <summary> Determines if two <see cref="StorageTargetType"/> values are the same. </summary>
        public static bool operator ==(StorageTargetType left, StorageTargetType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTargetType"/> values are not the same. </summary>
        public static bool operator !=(StorageTargetType left, StorageTargetType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTargetType"/>. </summary>
        public static implicit operator StorageTargetType(string value) => new StorageTargetType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTargetType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTargetType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
