// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Storage target operational state. </summary>
    public readonly partial struct StorageTargetOperationalStateType : IEquatable<StorageTargetOperationalStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTargetOperationalStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTargetOperationalStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadyValue = "Ready";
        private const string BusyValue = "Busy";
        private const string SuspendedValue = "Suspended";
        private const string FlushingValue = "Flushing";

        /// <summary> Ready. </summary>
        public static StorageTargetOperationalStateType Ready { get; } = new StorageTargetOperationalStateType(ReadyValue);
        /// <summary> Busy. </summary>
        public static StorageTargetOperationalStateType Busy { get; } = new StorageTargetOperationalStateType(BusyValue);
        /// <summary> Suspended. </summary>
        public static StorageTargetOperationalStateType Suspended { get; } = new StorageTargetOperationalStateType(SuspendedValue);
        /// <summary> Flushing. </summary>
        public static StorageTargetOperationalStateType Flushing { get; } = new StorageTargetOperationalStateType(FlushingValue);
        /// <summary> Determines if two <see cref="StorageTargetOperationalStateType"/> values are the same. </summary>
        public static bool operator ==(StorageTargetOperationalStateType left, StorageTargetOperationalStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTargetOperationalStateType"/> values are not the same. </summary>
        public static bool operator !=(StorageTargetOperationalStateType left, StorageTargetOperationalStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTargetOperationalStateType"/>. </summary>
        public static implicit operator StorageTargetOperationalStateType(string value) => new StorageTargetOperationalStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTargetOperationalStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTargetOperationalStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
