// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    public partial class StorageCacheUsernameDownloadSettings : IUtf8JsonSerializable, IJsonModel<StorageCacheUsernameDownloadSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageCacheUsernameDownloadSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageCacheUsernameDownloadSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EnableExtendedGroups))
            {
                writer.WritePropertyName("extendedGroups"u8);
                writer.WriteBooleanValue(EnableExtendedGroups.Value);
            }
            if (Optional.IsDefined(UsernameSource))
            {
                writer.WritePropertyName("usernameSource"u8);
                writer.WriteStringValue(UsernameSource.Value.ToString());
            }
            if (Optional.IsDefined(GroupFileUri))
            {
                writer.WritePropertyName("groupFileURI"u8);
                writer.WriteStringValue(GroupFileUri.AbsoluteUri);
            }
            if (Optional.IsDefined(UserFileUri))
            {
                writer.WritePropertyName("userFileURI"u8);
                writer.WriteStringValue(UserFileUri.AbsoluteUri);
            }
            if (Optional.IsDefined(LdapServer))
            {
                writer.WritePropertyName("ldapServer"u8);
                writer.WriteStringValue(LdapServer);
            }
            if (Optional.IsDefined(LdapBaseDN))
            {
                writer.WritePropertyName("ldapBaseDN"u8);
                writer.WriteStringValue(LdapBaseDN);
            }
            if (Optional.IsDefined(EncryptLdapConnection))
            {
                writer.WritePropertyName("encryptLdapConnection"u8);
                writer.WriteBooleanValue(EncryptLdapConnection.Value);
            }
            if (Optional.IsDefined(RequireValidCertificate))
            {
                writer.WritePropertyName("requireValidCertificate"u8);
                writer.WriteBooleanValue(RequireValidCertificate.Value);
            }
            if (Optional.IsDefined(AutoDownloadCertificate))
            {
                writer.WritePropertyName("autoDownloadCertificate"u8);
                writer.WriteBooleanValue(AutoDownloadCertificate.Value);
            }
            if (Optional.IsDefined(CaCertificateUri))
            {
                writer.WritePropertyName("caCertificateURI"u8);
                writer.WriteStringValue(CaCertificateUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(UsernameDownloaded))
            {
                writer.WritePropertyName("usernameDownloaded"u8);
                writer.WriteStringValue(UsernameDownloaded.Value.ToString());
            }
            if (Optional.IsDefined(Credentials))
            {
                writer.WritePropertyName("credentials"u8);
                writer.WriteObjectValue(Credentials, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageCacheUsernameDownloadSettings IJsonModel<StorageCacheUsernameDownloadSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageCacheUsernameDownloadSettings(document.RootElement, options);
        }

        internal static StorageCacheUsernameDownloadSettings DeserializeStorageCacheUsernameDownloadSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? extendedGroups = default;
            StorageCacheUsernameSourceType? usernameSource = default;
            Uri groupFileUri = default;
            Uri userFileUri = default;
            string ldapServer = default;
            string ldapBaseDN = default;
            bool? encryptLdapConnection = default;
            bool? requireValidCertificate = default;
            bool? autoDownloadCertificate = default;
            Uri caCertificateUri = default;
            StorageCacheUsernameDownloadedType? usernameDownloaded = default;
            StorageCacheUsernameDownloadCredential credentials = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("extendedGroups"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    extendedGroups = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("usernameSource"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usernameSource = new StorageCacheUsernameSourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("groupFileURI"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    groupFileUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("userFileURI"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userFileUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("ldapServer"u8))
                {
                    ldapServer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ldapBaseDN"u8))
                {
                    ldapBaseDN = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("encryptLdapConnection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encryptLdapConnection = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("requireValidCertificate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    requireValidCertificate = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("autoDownloadCertificate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoDownloadCertificate = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("caCertificateURI"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    caCertificateUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("usernameDownloaded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usernameDownloaded = new StorageCacheUsernameDownloadedType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("credentials"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    credentials = StorageCacheUsernameDownloadCredential.DeserializeStorageCacheUsernameDownloadCredential(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageCacheUsernameDownloadSettings(
                extendedGroups,
                usernameSource,
                groupFileUri,
                userFileUri,
                ldapServer,
                ldapBaseDN,
                encryptLdapConnection,
                requireValidCertificate,
                autoDownloadCertificate,
                caCertificateUri,
                usernameDownloaded,
                credentials,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageCacheUsernameDownloadSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadSettings)} does not support writing '{options.Format}' format.");
            }
        }

        StorageCacheUsernameDownloadSettings IPersistableModel<StorageCacheUsernameDownloadSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageCacheUsernameDownloadSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageCacheUsernameDownloadSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
