// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    public partial class StorageCacheUsernameDownloadCredential : IUtf8JsonSerializable, IJsonModel<StorageCacheUsernameDownloadCredential>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageCacheUsernameDownloadCredential>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageCacheUsernameDownloadCredential>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadCredential>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadCredential)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BindDistinguishedName))
            {
                writer.WritePropertyName("bindDn"u8);
                writer.WriteStringValue(BindDistinguishedName);
            }
            if (Optional.IsDefined(BindPassword))
            {
                writer.WritePropertyName("bindPassword"u8);
                writer.WriteStringValue(BindPassword);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageCacheUsernameDownloadCredential IJsonModel<StorageCacheUsernameDownloadCredential>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadCredential>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadCredential)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageCacheUsernameDownloadCredential(document.RootElement, options);
        }

        internal static StorageCacheUsernameDownloadCredential DeserializeStorageCacheUsernameDownloadCredential(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string bindDn = default;
            string bindPassword = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("bindDn"u8))
                {
                    bindDn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bindPassword"u8))
                {
                    bindPassword = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageCacheUsernameDownloadCredential(bindDn, bindPassword, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageCacheUsernameDownloadCredential>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadCredential>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadCredential)} does not support writing '{options.Format}' format.");
            }
        }

        StorageCacheUsernameDownloadCredential IPersistableModel<StorageCacheUsernameDownloadCredential>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageCacheUsernameDownloadCredential>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageCacheUsernameDownloadCredential(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageCacheUsernameDownloadCredential)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageCacheUsernameDownloadCredential>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
