// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> The usage and limit (quota) for a resource. </summary>
    public partial class StorageCacheUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCacheUsage"/>. </summary>
        internal StorageCacheUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageCacheUsage"/>. </summary>
        /// <param name="limit"> The limit (quota) for this resource. </param>
        /// <param name="unit"> Unit that the limit and usages are expressed in, such as 'Count'. </param>
        /// <param name="currentValue"> The current usage of this resource. </param>
        /// <param name="name"> Naming information for this resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCacheUsage(int? limit, string unit, int? currentValue, StorageCacheUsageName name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Limit = limit;
            Unit = unit;
            CurrentValue = currentValue;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The limit (quota) for this resource. </summary>
        public int? Limit { get; }
        /// <summary> Unit that the limit and usages are expressed in, such as 'Count'. </summary>
        public string Unit { get; }
        /// <summary> The current usage of this resource. </summary>
        public int? CurrentValue { get; }
        /// <summary> Naming information for this resource type. </summary>
        public StorageCacheUsageName Name { get; }
    }
}
