// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Properties describing the software upgrade state of the cache. </summary>
    public partial class StorageCacheUpgradeStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCacheUpgradeStatus"/>. </summary>
        internal StorageCacheUpgradeStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageCacheUpgradeStatus"/>. </summary>
        /// <param name="currentFirmwareVersion"> Version string of the firmware currently installed on this cache. </param>
        /// <param name="firmwareUpdateStatus"> True if there is a firmware update ready to install on this cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation. </param>
        /// <param name="firmwareUpdateDeadline"> Time at which the pending firmware update will automatically be installed on the cache. </param>
        /// <param name="lastFirmwareUpdate"> Time of the last successful firmware update. </param>
        /// <param name="pendingFirmwareVersion"> When firmwareUpdateAvailable is true, this field holds the version string for the update. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCacheUpgradeStatus(string currentFirmwareVersion, StorageCacheFirmwareStatusType? firmwareUpdateStatus, DateTimeOffset? firmwareUpdateDeadline, DateTimeOffset? lastFirmwareUpdate, string pendingFirmwareVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentFirmwareVersion = currentFirmwareVersion;
            FirmwareUpdateStatus = firmwareUpdateStatus;
            FirmwareUpdateDeadline = firmwareUpdateDeadline;
            LastFirmwareUpdate = lastFirmwareUpdate;
            PendingFirmwareVersion = pendingFirmwareVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Version string of the firmware currently installed on this cache. </summary>
        public string CurrentFirmwareVersion { get; }
        /// <summary> True if there is a firmware update ready to install on this cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation. </summary>
        public StorageCacheFirmwareStatusType? FirmwareUpdateStatus { get; }
        /// <summary> Time at which the pending firmware update will automatically be installed on the cache. </summary>
        public DateTimeOffset? FirmwareUpdateDeadline { get; }
        /// <summary> Time of the last successful firmware update. </summary>
        public DateTimeOffset? LastFirmwareUpdate { get; }
        /// <summary> When firmwareUpdateAvailable is true, this field holds the version string for the update. </summary>
        public string PendingFirmwareVersion { get; }
    }
}
