// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> A resource SKU. </summary>
    public partial class StorageCacheSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCacheSku"/>. </summary>
        internal StorageCacheSku()
        {
            Capabilities = new ChangeTrackingList<StorageCacheSkuCapability>();
            Locations = new ChangeTrackingList<string>();
            LocationInfo = new ChangeTrackingList<StorageCacheSkuLocationInfo>();
            Restrictions = new ChangeTrackingList<StorageCacheRestriction>();
        }

        /// <summary> Initializes a new instance of <see cref="StorageCacheSku"/>. </summary>
        /// <param name="resourceType"> The type of resource the SKU applies to. </param>
        /// <param name="capabilities"> A list of capabilities of this SKU, such as throughput or ops/sec. </param>
        /// <param name="locations"> The set of locations where the SKU is available. This is the supported and registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.). </param>
        /// <param name="locationInfo"> The set of locations where the SKU is available. </param>
        /// <param name="name"> The name of this SKU. </param>
        /// <param name="restrictions"> The restrictions preventing this SKU from being used. This is empty if there are no restrictions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCacheSku(string resourceType, IReadOnlyList<StorageCacheSkuCapability> capabilities, IReadOnlyList<string> locations, IReadOnlyList<StorageCacheSkuLocationInfo> locationInfo, string name, IReadOnlyList<StorageCacheRestriction> restrictions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceType = resourceType;
            Capabilities = capabilities;
            Locations = locations;
            LocationInfo = locationInfo;
            Name = name;
            Restrictions = restrictions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of resource the SKU applies to. </summary>
        public string ResourceType { get; }
        /// <summary> A list of capabilities of this SKU, such as throughput or ops/sec. </summary>
        public IReadOnlyList<StorageCacheSkuCapability> Capabilities { get; }
        /// <summary> The set of locations where the SKU is available. This is the supported and registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.). </summary>
        public IReadOnlyList<string> Locations { get; }
        /// <summary> The set of locations where the SKU is available. </summary>
        public IReadOnlyList<StorageCacheSkuLocationInfo> LocationInfo { get; }
        /// <summary> The name of this SKU. </summary>
        public string Name { get; }
        /// <summary> The restrictions preventing this SKU from being used. This is empty if there are no restrictions. </summary>
        public IReadOnlyList<StorageCacheRestriction> Restrictions { get; }
    }
}
