// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. "NotAvailableForSubscription" is related to capacity at the datacenter. </summary>
    public readonly partial struct StorageCacheRestrictionReasonCode : IEquatable<StorageCacheRestrictionReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageCacheRestrictionReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageCacheRestrictionReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QuotaIdValue = "QuotaId";
        private const string NotAvailableForSubscriptionValue = "NotAvailableForSubscription";

        /// <summary> QuotaId. </summary>
        public static StorageCacheRestrictionReasonCode QuotaId { get; } = new StorageCacheRestrictionReasonCode(QuotaIdValue);
        /// <summary> NotAvailableForSubscription. </summary>
        public static StorageCacheRestrictionReasonCode NotAvailableForSubscription { get; } = new StorageCacheRestrictionReasonCode(NotAvailableForSubscriptionValue);
        /// <summary> Determines if two <see cref="StorageCacheRestrictionReasonCode"/> values are the same. </summary>
        public static bool operator ==(StorageCacheRestrictionReasonCode left, StorageCacheRestrictionReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageCacheRestrictionReasonCode"/> values are not the same. </summary>
        public static bool operator !=(StorageCacheRestrictionReasonCode left, StorageCacheRestrictionReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageCacheRestrictionReasonCode"/>. </summary>
        public static implicit operator StorageCacheRestrictionReasonCode(string value) => new StorageCacheRestrictionReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageCacheRestrictionReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageCacheRestrictionReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
