// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property. </summary>
    public readonly partial struct StorageCacheProvisioningStateType : IEquatable<StorageCacheProvisioningStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageCacheProvisioningStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageCacheProvisioningStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";

        /// <summary> Succeeded. </summary>
        public static StorageCacheProvisioningStateType Succeeded { get; } = new StorageCacheProvisioningStateType(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageCacheProvisioningStateType Failed { get; } = new StorageCacheProvisioningStateType(FailedValue);
        /// <summary> Canceled. </summary>
        public static StorageCacheProvisioningStateType Canceled { get; } = new StorageCacheProvisioningStateType(CanceledValue);
        /// <summary> Creating. </summary>
        public static StorageCacheProvisioningStateType Creating { get; } = new StorageCacheProvisioningStateType(CreatingValue);
        /// <summary> Deleting. </summary>
        public static StorageCacheProvisioningStateType Deleting { get; } = new StorageCacheProvisioningStateType(DeletingValue);
        /// <summary> Updating. </summary>
        public static StorageCacheProvisioningStateType Updating { get; } = new StorageCacheProvisioningStateType(UpdatingValue);
        /// <summary> Determines if two <see cref="StorageCacheProvisioningStateType"/> values are the same. </summary>
        public static bool operator ==(StorageCacheProvisioningStateType left, StorageCacheProvisioningStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageCacheProvisioningStateType"/> values are not the same. </summary>
        public static bool operator !=(StorageCacheProvisioningStateType left, StorageCacheProvisioningStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageCacheProvisioningStateType"/>. </summary>
        public static implicit operator StorageCacheProvisioningStateType(string value) => new StorageCacheProvisioningStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageCacheProvisioningStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageCacheProvisioningStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
