// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Active Directory admin credentials used to join the HPC Cache to a domain. </summary>
    public partial class StorageCacheActiveDirectorySettingsCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageCacheActiveDirectorySettingsCredentials"/>. </summary>
        /// <param name="username"> Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="username"/> is null. </exception>
        public StorageCacheActiveDirectorySettingsCredentials(string username)
        {
            Argument.AssertNotNull(username, nameof(username));

            Username = username;
        }

        /// <summary> Initializes a new instance of <see cref="StorageCacheActiveDirectorySettingsCredentials"/>. </summary>
        /// <param name="username"> Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </param>
        /// <param name="password"> Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageCacheActiveDirectorySettingsCredentials(string username, string password, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageCacheActiveDirectorySettingsCredentials"/> for deserialization. </summary>
        internal StorageCacheActiveDirectorySettingsCredentials()
        {
        }
    }
}
