// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Information required to get the number of available IP addresses a subnet should have that will be used in AML file system create. </summary>
    public partial class RequiredAmlFileSystemSubnetsSizeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RequiredAmlFileSystemSubnetsSizeContent"/>. </summary>
        public RequiredAmlFileSystemSubnetsSizeContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RequiredAmlFileSystemSubnetsSizeContent"/>. </summary>
        /// <param name="storageCapacityTiB"> The size of the AML file system, in TiB. </param>
        /// <param name="sku"> SKU for the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RequiredAmlFileSystemSubnetsSizeContent(float? storageCapacityTiB, StorageCacheSkuName sku, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageCapacityTiB = storageCapacityTiB;
            Sku = sku;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The size of the AML file system, in TiB. </summary>
        public float? StorageCapacityTiB { get; set; }
        /// <summary> SKU for the resource. </summary>
        internal StorageCacheSkuName Sku { get; set; }
        /// <summary> SKU name for this resource. </summary>
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new StorageCacheSkuName();
                Sku.Name = value;
            }
        }
    }
}
