// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> The state of the priming operation. </summary>
    public readonly partial struct PrimingJobState : IEquatable<PrimingJobState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrimingJobState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrimingJobState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QueuedValue = "Queued";
        private const string RunningValue = "Running";
        private const string PausedValue = "Paused";
        private const string CompleteValue = "Complete";

        /// <summary> Queued. </summary>
        public static PrimingJobState Queued { get; } = new PrimingJobState(QueuedValue);
        /// <summary> Running. </summary>
        public static PrimingJobState Running { get; } = new PrimingJobState(RunningValue);
        /// <summary> Paused. </summary>
        public static PrimingJobState Paused { get; } = new PrimingJobState(PausedValue);
        /// <summary> Complete. </summary>
        public static PrimingJobState Complete { get; } = new PrimingJobState(CompleteValue);
        /// <summary> Determines if two <see cref="PrimingJobState"/> values are the same. </summary>
        public static bool operator ==(PrimingJobState left, PrimingJobState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrimingJobState"/> values are not the same. </summary>
        public static bool operator !=(PrimingJobState left, PrimingJobState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrimingJobState"/>. </summary>
        public static implicit operator PrimingJobState(string value) => new PrimingJobState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrimingJobState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrimingJobState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
