// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    public partial class PrimingJob : IUtf8JsonSerializable, IJsonModel<PrimingJob>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PrimingJob>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PrimingJob>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrimingJob>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PrimingJob)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("primingJobName"u8);
            writer.WriteStringValue(PrimingJobName);
            writer.WritePropertyName("primingManifestUrl"u8);
            writer.WriteStringValue(PrimingManifestUri.AbsoluteUri);
            if (options.Format != "W" && Optional.IsDefined(PrimingJobId))
            {
                writer.WritePropertyName("primingJobId"u8);
                writer.WriteStringValue(PrimingJobId);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimingJobState))
            {
                writer.WritePropertyName("primingJobState"u8);
                writer.WriteStringValue(PrimingJobState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PrimingJobStatus))
            {
                writer.WritePropertyName("primingJobStatus"u8);
                writer.WriteStringValue(PrimingJobStatus);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimingJobDetails))
            {
                writer.WritePropertyName("primingJobDetails"u8);
                writer.WriteStringValue(PrimingJobDetails);
            }
            if (options.Format != "W" && Optional.IsDefined(PrimingJobPercentComplete))
            {
                writer.WritePropertyName("primingJobPercentComplete"u8);
                writer.WriteNumberValue(PrimingJobPercentComplete.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PrimingJob IJsonModel<PrimingJob>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrimingJob>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PrimingJob)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePrimingJob(document.RootElement, options);
        }

        internal static PrimingJob DeserializePrimingJob(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string primingJobName = default;
            Uri primingManifestUrl = default;
            string primingJobId = default;
            PrimingJobState? primingJobState = default;
            string primingJobStatus = default;
            string primingJobDetails = default;
            double? primingJobPercentComplete = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primingJobName"u8))
                {
                    primingJobName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primingManifestUrl"u8))
                {
                    primingManifestUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primingJobId"u8))
                {
                    primingJobId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primingJobState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primingJobState = new PrimingJobState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primingJobStatus"u8))
                {
                    primingJobStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primingJobDetails"u8))
                {
                    primingJobDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primingJobPercentComplete"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primingJobPercentComplete = property.Value.GetDouble();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PrimingJob(
                primingJobName,
                primingManifestUrl,
                primingJobId,
                primingJobState,
                primingJobStatus,
                primingJobDetails,
                primingJobPercentComplete,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PrimingJob>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrimingJob>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PrimingJob)} does not support writing '{options.Format}' format.");
            }
        }

        PrimingJob IPersistableModel<PrimingJob>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PrimingJob>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePrimingJob(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PrimingJob)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PrimingJob>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
