// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Scope for this rule. The scope and filter determine which clients match the rule. </summary>
    public readonly partial struct NfsAccessRuleScope : IEquatable<NfsAccessRuleScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NfsAccessRuleScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NfsAccessRuleScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";
        private const string NetworkValue = "network";
        private const string HostValue = "host";

        /// <summary> default. </summary>
        public static NfsAccessRuleScope Default { get; } = new NfsAccessRuleScope(DefaultValue);
        /// <summary> network. </summary>
        public static NfsAccessRuleScope Network { get; } = new NfsAccessRuleScope(NetworkValue);
        /// <summary> host. </summary>
        public static NfsAccessRuleScope Host { get; } = new NfsAccessRuleScope(HostValue);
        /// <summary> Determines if two <see cref="NfsAccessRuleScope"/> values are the same. </summary>
        public static bool operator ==(NfsAccessRuleScope left, NfsAccessRuleScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NfsAccessRuleScope"/> values are not the same. </summary>
        public static bool operator !=(NfsAccessRuleScope left, NfsAccessRuleScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NfsAccessRuleScope"/>. </summary>
        public static implicit operator NfsAccessRuleScope(string value) => new NfsAccessRuleScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NfsAccessRuleScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NfsAccessRuleScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
