// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    public partial class NfsAccessRule : IUtf8JsonSerializable, IJsonModel<NfsAccessRule>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NfsAccessRule>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NfsAccessRule>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsAccessRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NfsAccessRule)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("scope"u8);
            writer.WriteStringValue(Scope.ToString());
            if (Optional.IsDefined(Filter))
            {
                writer.WritePropertyName("filter"u8);
                writer.WriteStringValue(Filter);
            }
            writer.WritePropertyName("access"u8);
            writer.WriteStringValue(Access.ToString());
            if (Optional.IsDefined(AllowSuid))
            {
                writer.WritePropertyName("suid"u8);
                writer.WriteBooleanValue(AllowSuid.Value);
            }
            if (Optional.IsDefined(AllowSubmountAccess))
            {
                writer.WritePropertyName("submountAccess"u8);
                writer.WriteBooleanValue(AllowSubmountAccess.Value);
            }
            if (Optional.IsDefined(EnableRootSquash))
            {
                writer.WritePropertyName("rootSquash"u8);
                writer.WriteBooleanValue(EnableRootSquash.Value);
            }
            if (Optional.IsDefined(AnonymousUID))
            {
                writer.WritePropertyName("anonymousUID"u8);
                writer.WriteStringValue(AnonymousUID);
            }
            if (Optional.IsDefined(AnonymousGID))
            {
                writer.WritePropertyName("anonymousGID"u8);
                writer.WriteStringValue(AnonymousGID);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NfsAccessRule IJsonModel<NfsAccessRule>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsAccessRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NfsAccessRule)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNfsAccessRule(document.RootElement, options);
        }

        internal static NfsAccessRule DeserializeNfsAccessRule(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            NfsAccessRuleScope scope = default;
            string filter = default;
            NfsAccessRuleAccess access = default;
            bool? suid = default;
            bool? submountAccess = default;
            bool? rootSquash = default;
            string anonymousUID = default;
            string anonymousGID = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("scope"u8))
                {
                    scope = new NfsAccessRuleScope(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("filter"u8))
                {
                    filter = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("access"u8))
                {
                    access = new NfsAccessRuleAccess(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("suid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    suid = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("submountAccess"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    submountAccess = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("rootSquash"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rootSquash = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("anonymousUID"u8))
                {
                    anonymousUID = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("anonymousGID"u8))
                {
                    anonymousGID = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NfsAccessRule(
                scope,
                filter,
                access,
                suid,
                submountAccess,
                rootSquash,
                anonymousUID,
                anonymousGID,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NfsAccessRule>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsAccessRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NfsAccessRule)} does not support writing '{options.Format}' format.");
            }
        }

        NfsAccessRule IPersistableModel<NfsAccessRule>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NfsAccessRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNfsAccessRule(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NfsAccessRule)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NfsAccessRule>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
