// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> The state of the import job. InProgress indicates the import is still running. Canceled indicates it has been canceled by the user. Completed indicates import finished, successfully importing all discovered blobs into the Lustre namespace. CompletedPartial indicates the import finished but some blobs either were found to be conflicting and could not be imported or other errors were encountered. Failed means the import was unable to complete due to a fatal error. </summary>
    public readonly partial struct ImportStatusType : IEquatable<ImportStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImportStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImportStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string CancellingValue = "Cancelling";
        private const string CanceledValue = "Canceled";
        private const string CompletedValue = "Completed";
        private const string CompletedPartialValue = "CompletedPartial";
        private const string FailedValue = "Failed";

        /// <summary> InProgress. </summary>
        public static ImportStatusType InProgress { get; } = new ImportStatusType(InProgressValue);
        /// <summary> Cancelling. </summary>
        public static ImportStatusType Cancelling { get; } = new ImportStatusType(CancellingValue);
        /// <summary> Canceled. </summary>
        public static ImportStatusType Canceled { get; } = new ImportStatusType(CanceledValue);
        /// <summary> Completed. </summary>
        public static ImportStatusType Completed { get; } = new ImportStatusType(CompletedValue);
        /// <summary> CompletedPartial. </summary>
        public static ImportStatusType CompletedPartial { get; } = new ImportStatusType(CompletedPartialValue);
        /// <summary> Failed. </summary>
        public static ImportStatusType Failed { get; } = new ImportStatusType(FailedValue);
        /// <summary> Determines if two <see cref="ImportStatusType"/> values are the same. </summary>
        public static bool operator ==(ImportStatusType left, ImportStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImportStatusType"/> values are not the same. </summary>
        public static bool operator !=(ImportStatusType left, ImportStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImportStatusType"/>. </summary>
        public static implicit operator ImportStatusType(string value) => new ImportStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImportStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImportStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
