// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> ARM provisioning state. </summary>
    public readonly partial struct ImportJobProvisioningStateType : IEquatable<ImportJobProvisioningStateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImportJobProvisioningStateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImportJobProvisioningStateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";
        private const string CanceledValue = "Canceled";

        /// <summary> Succeeded. </summary>
        public static ImportJobProvisioningStateType Succeeded { get; } = new ImportJobProvisioningStateType(SucceededValue);
        /// <summary> Failed. </summary>
        public static ImportJobProvisioningStateType Failed { get; } = new ImportJobProvisioningStateType(FailedValue);
        /// <summary> Creating. </summary>
        public static ImportJobProvisioningStateType Creating { get; } = new ImportJobProvisioningStateType(CreatingValue);
        /// <summary> Deleting. </summary>
        public static ImportJobProvisioningStateType Deleting { get; } = new ImportJobProvisioningStateType(DeletingValue);
        /// <summary> Updating. </summary>
        public static ImportJobProvisioningStateType Updating { get; } = new ImportJobProvisioningStateType(UpdatingValue);
        /// <summary> Canceled. </summary>
        public static ImportJobProvisioningStateType Canceled { get; } = new ImportJobProvisioningStateType(CanceledValue);
        /// <summary> Determines if two <see cref="ImportJobProvisioningStateType"/> values are the same. </summary>
        public static bool operator ==(ImportJobProvisioningStateType left, ImportJobProvisioningStateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImportJobProvisioningStateType"/> values are not the same. </summary>
        public static bool operator !=(ImportJobProvisioningStateType left, ImportJobProvisioningStateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImportJobProvisioningStateType"/>. </summary>
        public static implicit operator ImportJobProvisioningStateType(string value) => new ImportJobProvisioningStateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImportJobProvisioningStateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImportJobProvisioningStateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
