// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> True if the HPC Cache is joined to the Active Directory domain. </summary>
    public readonly partial struct DomainJoinedType : IEquatable<DomainJoinedType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DomainJoinedType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DomainJoinedType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YesValue = "Yes";
        private const string NoValue = "No";
        private const string ErrorValue = "Error";

        /// <summary> Yes. </summary>
        public static DomainJoinedType Yes { get; } = new DomainJoinedType(YesValue);
        /// <summary> No. </summary>
        public static DomainJoinedType No { get; } = new DomainJoinedType(NoValue);
        /// <summary> Error. </summary>
        public static DomainJoinedType Error { get; } = new DomainJoinedType(ErrorValue);
        /// <summary> Determines if two <see cref="DomainJoinedType"/> values are the same. </summary>
        public static bool operator ==(DomainJoinedType left, DomainJoinedType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DomainJoinedType"/> values are not the same. </summary>
        public static bool operator !=(DomainJoinedType left, DomainJoinedType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DomainJoinedType"/>. </summary>
        public static implicit operator DomainJoinedType(string value) => new DomainJoinedType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DomainJoinedType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DomainJoinedType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
