// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes. </summary>
    public readonly partial struct ConflictResolutionMode : IEquatable<ConflictResolutionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConflictResolutionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConflictResolutionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailValue = "Fail";
        private const string SkipValue = "Skip";
        private const string OverwriteIfDirtyValue = "OverwriteIfDirty";
        private const string OverwriteAlwaysValue = "OverwriteAlways";

        /// <summary> Fail. </summary>
        public static ConflictResolutionMode Fail { get; } = new ConflictResolutionMode(FailValue);
        /// <summary> Skip. </summary>
        public static ConflictResolutionMode Skip { get; } = new ConflictResolutionMode(SkipValue);
        /// <summary> OverwriteIfDirty. </summary>
        public static ConflictResolutionMode OverwriteIfDirty { get; } = new ConflictResolutionMode(OverwriteIfDirtyValue);
        /// <summary> OverwriteAlways. </summary>
        public static ConflictResolutionMode OverwriteAlways { get; } = new ConflictResolutionMode(OverwriteAlwaysValue);
        /// <summary> Determines if two <see cref="ConflictResolutionMode"/> values are the same. </summary>
        public static bool operator ==(ConflictResolutionMode left, ConflictResolutionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConflictResolutionMode"/> values are not the same. </summary>
        public static bool operator !=(ConflictResolutionMode left, ConflictResolutionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConflictResolutionMode"/>. </summary>
        public static implicit operator ConflictResolutionMode(string value) => new ConflictResolutionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConflictResolutionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConflictResolutionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
