// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    public partial class BlobNfsTarget : IUtf8JsonSerializable, IJsonModel<BlobNfsTarget>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BlobNfsTarget>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BlobNfsTarget>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobNfsTarget>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BlobNfsTarget)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Target))
            {
                writer.WritePropertyName("target"u8);
                writer.WriteStringValue(Target);
            }
            if (Optional.IsDefined(UsageModel))
            {
                writer.WritePropertyName("usageModel"u8);
                writer.WriteStringValue(UsageModel);
            }
            if (Optional.IsDefined(VerificationDelayInSeconds))
            {
                writer.WritePropertyName("verificationTimer"u8);
                writer.WriteNumberValue(VerificationDelayInSeconds.Value);
            }
            if (Optional.IsDefined(WriteBackDelayInSeconds))
            {
                writer.WritePropertyName("writeBackTimer"u8);
                writer.WriteNumberValue(WriteBackDelayInSeconds.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BlobNfsTarget IJsonModel<BlobNfsTarget>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobNfsTarget>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BlobNfsTarget)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBlobNfsTarget(document.RootElement, options);
        }

        internal static BlobNfsTarget DeserializeBlobNfsTarget(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier target = default;
            string usageModel = default;
            int? verificationTimer = default;
            int? writeBackTimer = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("target"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    target = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("usageModel"u8))
                {
                    usageModel = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("verificationTimer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    verificationTimer = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("writeBackTimer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    writeBackTimer = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BlobNfsTarget(target, usageModel, verificationTimer, writeBackTimer, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BlobNfsTarget>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobNfsTarget>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BlobNfsTarget)} does not support writing '{options.Format}' format.");
            }
        }

        BlobNfsTarget IPersistableModel<BlobNfsTarget>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BlobNfsTarget>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBlobNfsTarget(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BlobNfsTarget)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BlobNfsTarget>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
