// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Information required to validate the subnet that will be used in AML file system create. </summary>
    public partial class AmlFileSystemSubnetContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemSubnetContent"/>. </summary>
        public AmlFileSystemSubnetContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemSubnetContent"/>. </summary>
        /// <param name="filesystemSubnet"> Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space. </param>
        /// <param name="storageCapacityTiB"> The size of the AML file system, in TiB. </param>
        /// <param name="sku"> SKU for the resource. </param>
        /// <param name="location"> Region that the AML file system will be created in. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AmlFileSystemSubnetContent(string filesystemSubnet, float? storageCapacityTiB, StorageCacheSkuName sku, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FilesystemSubnet = filesystemSubnet;
            StorageCapacityTiB = storageCapacityTiB;
            Sku = sku;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space. </summary>
        public string FilesystemSubnet { get; set; }
        /// <summary> The size of the AML file system, in TiB. </summary>
        public float? StorageCapacityTiB { get; set; }
        /// <summary> SKU for the resource. </summary>
        internal StorageCacheSkuName Sku { get; set; }
        /// <summary> SKU name for this resource. </summary>
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set
            {
                if (Sku is null)
                    Sku = new StorageCacheSkuName();
                Sku.Name = value;
            }
        }

        /// <summary> Region that the AML file system will be created in. </summary>
        public AzureLocation? Location { get; set; }
    }
}
