// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Squash mode of the AML file system. 'All': User and Group IDs on files will be squashed to the provided values for all users on non-trusted systems. 'RootOnly': User and Group IDs on files will be squashed to provided values for solely the root user on non-trusted systems. 'None': No squashing of User and Group IDs is performed for any users on any systems. </summary>
    public readonly partial struct AmlFileSystemSquashMode : IEquatable<AmlFileSystemSquashMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemSquashMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AmlFileSystemSquashMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string RootOnlyValue = "RootOnly";
        private const string AllValue = "All";

        /// <summary> None. </summary>
        public static AmlFileSystemSquashMode None { get; } = new AmlFileSystemSquashMode(NoneValue);
        /// <summary> RootOnly. </summary>
        public static AmlFileSystemSquashMode RootOnly { get; } = new AmlFileSystemSquashMode(RootOnlyValue);
        /// <summary> All. </summary>
        public static AmlFileSystemSquashMode All { get; } = new AmlFileSystemSquashMode(AllValue);
        /// <summary> Determines if two <see cref="AmlFileSystemSquashMode"/> values are the same. </summary>
        public static bool operator ==(AmlFileSystemSquashMode left, AmlFileSystemSquashMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AmlFileSystemSquashMode"/> values are not the same. </summary>
        public static bool operator !=(AmlFileSystemSquashMode left, AmlFileSystemSquashMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AmlFileSystemSquashMode"/>. </summary>
        public static implicit operator AmlFileSystemSquashMode(string value) => new AmlFileSystemSquashMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AmlFileSystemSquashMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AmlFileSystemSquashMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
