// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> An AML file system update instance. </summary>
    public partial class AmlFileSystemPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemPatch"/>. </summary>
        public AmlFileSystemPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="encryptionSettings"> Specifies encryption settings of the AML file system. </param>
        /// <param name="maintenanceWindow"> Start time of a 30-minute weekly maintenance window. </param>
        /// <param name="rootSquashSettings"> Specifies root squash settings of the AML file system. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AmlFileSystemPatch(IDictionary<string, string> tags, AmlFileSystemEncryptionSettings encryptionSettings, AmlFileSystemUpdatePropertiesMaintenanceWindow maintenanceWindow, AmlFileSystemRootSquashSettings rootSquashSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            EncryptionSettings = encryptionSettings;
            MaintenanceWindow = maintenanceWindow;
            RootSquashSettings = rootSquashSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Specifies encryption settings of the AML file system. </summary>
        internal AmlFileSystemEncryptionSettings EncryptionSettings { get; set; }
        /// <summary> Specifies the location of the encryption key in Key Vault. </summary>
        public StorageCacheEncryptionKeyVaultKeyReference KeyEncryptionKey
        {
            get => EncryptionSettings is null ? default : EncryptionSettings.KeyEncryptionKey;
            set
            {
                if (EncryptionSettings is null)
                    EncryptionSettings = new AmlFileSystemEncryptionSettings();
                EncryptionSettings.KeyEncryptionKey = value;
            }
        }

        /// <summary> Start time of a 30-minute weekly maintenance window. </summary>
        public AmlFileSystemUpdatePropertiesMaintenanceWindow MaintenanceWindow { get; set; }
        /// <summary> Specifies root squash settings of the AML file system. </summary>
        public AmlFileSystemRootSquashSettings RootSquashSettings { get; set; }
    }
}
