// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> The status of the archive. </summary>
    public partial class AmlFileSystemArchiveStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemArchiveStatus"/>. </summary>
        internal AmlFileSystemArchiveStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AmlFileSystemArchiveStatus"/>. </summary>
        /// <param name="state"> The state of the archive operation. </param>
        /// <param name="lastCompletionOn"> The time of the last completed archive operation. </param>
        /// <param name="lastStartedOn"> The time the latest archive operation started. </param>
        /// <param name="percentComplete"> The completion percentage of the archive operation. </param>
        /// <param name="errorCode"> Server-defined error code for the archive operation. </param>
        /// <param name="errorMessage"> Server-defined error message for the archive operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AmlFileSystemArchiveStatus(ArchiveStatusType? state, DateTimeOffset? lastCompletionOn, DateTimeOffset? lastStartedOn, int? percentComplete, string errorCode, string errorMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            LastCompletionOn = lastCompletionOn;
            LastStartedOn = lastStartedOn;
            PercentComplete = percentComplete;
            ErrorCode = errorCode;
            ErrorMessage = errorMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The state of the archive operation. </summary>
        public ArchiveStatusType? State { get; }
        /// <summary> The time of the last completed archive operation. </summary>
        public DateTimeOffset? LastCompletionOn { get; }
        /// <summary> The time the latest archive operation started. </summary>
        public DateTimeOffset? LastStartedOn { get; }
        /// <summary> The completion percentage of the archive operation. </summary>
        public int? PercentComplete { get; }
        /// <summary> Server-defined error code for the archive operation. </summary>
        public string ErrorCode { get; }
        /// <summary> Server-defined error message for the archive operation. </summary>
        public string ErrorMessage { get; }
    }
}
