// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.StorageCache
{
    internal class StorageCacheImportJobOperationSource : IOperationSource<StorageCacheImportJobResource>
    {
        private readonly ArmClient _client;

        internal StorageCacheImportJobOperationSource(ArmClient client)
        {
            _client = client;
        }

        StorageCacheImportJobResource IOperationSource<StorageCacheImportJobResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = StorageCacheImportJobData.DeserializeStorageCacheImportJobData(document.RootElement);
            return new StorageCacheImportJobResource(_client, data);
        }

        async ValueTask<StorageCacheImportJobResource> IOperationSource<StorageCacheImportJobResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = StorageCacheImportJobData.DeserializeStorageCacheImportJobData(document.RootElement);
            return new StorageCacheImportJobResource(_client, data);
        }
    }
}
