// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmStorageCacheModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="StorageCache.AmlFileSystemData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The managed identity used by the AML file system, if configured. Current supported identity types: None, UserAssigned. </param>
        /// <param name="skuName"> SKU for the resource. </param>
        /// <param name="zones"> Availability zones for resources. This field should only contain a single element in the array. </param>
        /// <param name="storageCapacityTiB"> The size of the AML file system, in TiB. This might be rounded up. </param>
        /// <param name="health"> Health of the AML file system. </param>
        /// <param name="provisioningState"> ARM provisioning state. </param>
        /// <param name="filesystemSubnet"> Subnet used for managing the AML file system and for client-facing operations. This subnet should have at least a /24 subnet mask within the VNET's address space. </param>
        /// <param name="clientInfo"> Client information for the AML file system. </param>
        /// <param name="throughputProvisionedMBps"> Throughput provisioned in MB per sec, calculated as storageCapacityTiB * per-unit storage throughput. </param>
        /// <param name="keyEncryptionKey"> Specifies encryption settings of the AML file system. </param>
        /// <param name="maintenanceWindow"> Start time of a 30-minute weekly maintenance window. </param>
        /// <param name="hsm"> Hydration and archive settings and status. </param>
        /// <param name="rootSquashSettings"> Specifies root squash settings of the AML file system. </param>
        /// <returns> A new <see cref="StorageCache.AmlFileSystemData"/> instance for mocking. </returns>
        public static AmlFileSystemData AmlFileSystemData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string skuName = null, IEnumerable<string> zones = null, float? storageCapacityTiB = null, AmlFileSystemHealth health = null, AmlFileSystemProvisioningStateType? provisioningState = null, string filesystemSubnet = null, AmlFileSystemClientInfo clientInfo = null, int? throughputProvisionedMBps = null, StorageCacheEncryptionKeyVaultKeyReference keyEncryptionKey = null, AmlFileSystemPropertiesMaintenanceWindow maintenanceWindow = null, AmlFileSystemPropertiesHsm hsm = null, AmlFileSystemRootSquashSettings rootSquashSettings = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();

            return new AmlFileSystemData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                skuName != null ? new StorageCacheSkuName(skuName, serializedAdditionalRawData: null) : null,
                zones?.ToList(),
                storageCapacityTiB,
                health,
                provisioningState,
                filesystemSubnet,
                clientInfo,
                throughputProvisionedMBps,
                keyEncryptionKey != null ? new AmlFileSystemEncryptionSettings(keyEncryptionKey, serializedAdditionalRawData: null) : null,
                maintenanceWindow,
                hsm,
                rootSquashSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemHealth"/>. </summary>
        /// <param name="state"> List of AML file system health states. </param>
        /// <param name="statusCode"> Server-defined error code for the AML file system health. </param>
        /// <param name="statusDescription"> Describes the health state. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemHealth"/> instance for mocking. </returns>
        public static AmlFileSystemHealth AmlFileSystemHealth(AmlFileSystemHealthStateType? state = null, string statusCode = null, string statusDescription = null)
        {
            return new AmlFileSystemHealth(state, statusCode, statusDescription, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemClientInfo"/>. </summary>
        /// <param name="mgsAddress"> The IPv4 address used by clients to mount the AML file system's Lustre Management Service (MGS). </param>
        /// <param name="mountCommand"> Recommended command to mount the AML file system. </param>
        /// <param name="lustreVersion"> The version of Lustre running in the AML file system. </param>
        /// <param name="containerStorageInterface"> Container Storage Interface information for the AML file system. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemClientInfo"/> instance for mocking. </returns>
        public static AmlFileSystemClientInfo AmlFileSystemClientInfo(string mgsAddress = null, string mountCommand = null, string lustreVersion = null, AmlFileSystemContainerStorageInterface containerStorageInterface = null)
        {
            return new AmlFileSystemClientInfo(mgsAddress, mountCommand, lustreVersion, containerStorageInterface, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemContainerStorageInterface"/>. </summary>
        /// <param name="persistentVolumeClaim"> Recommended AKS Persistent Volume Claim for the CSI driver, in Base64 encoded YAML. </param>
        /// <param name="persistentVolume"> Recommended AKS Persistent Volume for the CSI driver, in Base64 encoded YAML. </param>
        /// <param name="storageClass"> Recommended AKS Storage Class for the CSI driver, in Base64 encoded YAML. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemContainerStorageInterface"/> instance for mocking. </returns>
        public static AmlFileSystemContainerStorageInterface AmlFileSystemContainerStorageInterface(string persistentVolumeClaim = null, string persistentVolume = null, string storageClass = null)
        {
            return new AmlFileSystemContainerStorageInterface(persistentVolumeClaim, persistentVolume, storageClass, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemPropertiesHsm"/>. </summary>
        /// <param name="settings"> Specifies HSM settings of the AML file system. </param>
        /// <param name="archiveStatus"> Archive status. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemPropertiesHsm"/> instance for mocking. </returns>
        public static AmlFileSystemPropertiesHsm AmlFileSystemPropertiesHsm(AmlFileSystemHsmSettings settings = null, IEnumerable<AmlFileSystemArchive> archiveStatus = null)
        {
            archiveStatus ??= new List<AmlFileSystemArchive>();

            return new AmlFileSystemPropertiesHsm(settings, archiveStatus?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemArchive"/>. </summary>
        /// <param name="filesystemPath"> Lustre file system path to archive relative to the file system root.  Specify '/' to archive all modified data. </param>
        /// <param name="status"> The status of the archive. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemArchive"/> instance for mocking. </returns>
        public static AmlFileSystemArchive AmlFileSystemArchive(string filesystemPath = null, AmlFileSystemArchiveStatus status = null)
        {
            return new AmlFileSystemArchive(filesystemPath, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemArchiveStatus"/>. </summary>
        /// <param name="state"> The state of the archive operation. </param>
        /// <param name="lastCompletionOn"> The time of the last completed archive operation. </param>
        /// <param name="lastStartedOn"> The time the latest archive operation started. </param>
        /// <param name="percentComplete"> The completion percentage of the archive operation. </param>
        /// <param name="errorCode"> Server-defined error code for the archive operation. </param>
        /// <param name="errorMessage"> Server-defined error message for the archive operation. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemArchiveStatus"/> instance for mocking. </returns>
        public static AmlFileSystemArchiveStatus AmlFileSystemArchiveStatus(ArchiveStatusType? state = null, DateTimeOffset? lastCompletionOn = null, DateTimeOffset? lastStartedOn = null, int? percentComplete = null, string errorCode = null, string errorMessage = null)
        {
            return new AmlFileSystemArchiveStatus(
                state,
                lastCompletionOn,
                lastStartedOn,
                percentComplete,
                errorCode,
                errorMessage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AmlFileSystemRootSquashSettings"/>. </summary>
        /// <param name="mode"> Squash mode of the AML file system. 'All': User and Group IDs on files will be squashed to the provided values for all users on non-trusted systems. 'RootOnly': User and Group IDs on files will be squashed to provided values for solely the root user on non-trusted systems. 'None': No squashing of User and Group IDs is performed for any users on any systems. </param>
        /// <param name="noSquashNidLists"> Semicolon separated NID IP Address list(s) to be added to the TrustedSystems. </param>
        /// <param name="squashUID"> User ID to squash to. </param>
        /// <param name="squashGID"> Group ID to squash to. </param>
        /// <param name="status"> AML file system squash status. </param>
        /// <returns> A new <see cref="Models.AmlFileSystemRootSquashSettings"/> instance for mocking. </returns>
        public static AmlFileSystemRootSquashSettings AmlFileSystemRootSquashSettings(AmlFileSystemSquashMode? mode = null, string noSquashNidLists = null, long? squashUID = null, long? squashGID = null, string status = null)
        {
            return new AmlFileSystemRootSquashSettings(
                mode,
                noSquashNidLists,
                squashUID,
                squashGID,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageCache.StorageCacheImportJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> ARM provisioning state. </param>
        /// <param name="importPrefixes"> An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value. </param>
        /// <param name="conflictResolutionMode"> How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes. </param>
        /// <param name="maximumErrors"> Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default. </param>
        /// <param name="state"> The state of the import job. InProgress indicates the import is still running. Canceled indicates it has been canceled by the user. Completed indicates import finished, successfully importing all discovered blobs into the Lustre namespace. CompletedPartial indicates the import finished but some blobs either were found to be conflicting and could not be imported or other errors were encountered. Failed means the import was unable to complete due to a fatal error. </param>
        /// <param name="statusMessage"> The status message of the import job. </param>
        /// <param name="totalBlobsWalked"> The total blob objects walked. </param>
        /// <param name="blobsWalkedPerSecond"> A recent and frequently updated rate of blobs walked per second. </param>
        /// <param name="totalBlobsImported"> The total blobs that have been imported since import began. </param>
        /// <param name="blobsImportedPerSecond"> A recent and frequently updated rate of total files, directories, and symlinks imported per second. </param>
        /// <param name="lastCompletionOn"> The time of the last completed archive operation. </param>
        /// <param name="lastStartedOn"> The time the latest archive operation started. </param>
        /// <param name="totalErrors"> Number of errors in the import job. </param>
        /// <param name="totalConflicts"> Number of conflicts in the import job. </param>
        /// <returns> A new <see cref="StorageCache.StorageCacheImportJobData"/> instance for mocking. </returns>
        public static StorageCacheImportJobData StorageCacheImportJobData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ImportJobProvisioningStateType? provisioningState = null, IEnumerable<string> importPrefixes = null, ConflictResolutionMode? conflictResolutionMode = null, int? maximumErrors = null, ImportStatusType? state = null, string statusMessage = null, long? totalBlobsWalked = null, long? blobsWalkedPerSecond = null, long? totalBlobsImported = null, long? blobsImportedPerSecond = null, DateTimeOffset? lastCompletionOn = null, DateTimeOffset? lastStartedOn = null, int? totalErrors = null, int? totalConflicts = null)
        {
            tags ??= new Dictionary<string, string>();
            importPrefixes ??= new List<string>();

            return new StorageCacheImportJobData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                importPrefixes?.ToList(),
                conflictResolutionMode,
                maximumErrors,
                state,
                statusMessage,
                totalBlobsWalked,
                blobsWalkedPerSecond,
                totalBlobsImported,
                blobsImportedPerSecond,
                lastCompletionOn,
                lastStartedOn,
                totalErrors,
                totalConflicts,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RequiredAmlFileSystemSubnetsSize"/>. </summary>
        /// <param name="filesystemSubnetSize"> The number of available IP addresses that are required for the AML file system. </param>
        /// <returns> A new <see cref="Models.RequiredAmlFileSystemSubnetsSize"/> instance for mocking. </returns>
        public static RequiredAmlFileSystemSubnetsSize RequiredAmlFileSystemSubnetsSize(int? filesystemSubnetSize = null)
        {
            return new RequiredAmlFileSystemSubnetsSize(filesystemSubnetSize, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheSku"/>. </summary>
        /// <param name="resourceType"> The type of resource the SKU applies to. </param>
        /// <param name="capabilities"> A list of capabilities of this SKU, such as throughput or ops/sec. </param>
        /// <param name="locations"> The set of locations where the SKU is available. This is the supported and registered Azure Geo Regions (e.g., West US, East US, Southeast Asia, etc.). </param>
        /// <param name="locationInfo"> The set of locations where the SKU is available. </param>
        /// <param name="name"> The name of this SKU. </param>
        /// <param name="restrictions"> The restrictions preventing this SKU from being used. This is empty if there are no restrictions. </param>
        /// <returns> A new <see cref="Models.StorageCacheSku"/> instance for mocking. </returns>
        public static StorageCacheSku StorageCacheSku(string resourceType = null, IEnumerable<StorageCacheSkuCapability> capabilities = null, IEnumerable<string> locations = null, IEnumerable<StorageCacheSkuLocationInfo> locationInfo = null, string name = null, IEnumerable<StorageCacheRestriction> restrictions = null)
        {
            capabilities ??= new List<StorageCacheSkuCapability>();
            locations ??= new List<string>();
            locationInfo ??= new List<StorageCacheSkuLocationInfo>();
            restrictions ??= new List<StorageCacheRestriction>();

            return new StorageCacheSku(
                resourceType,
                capabilities?.ToList(),
                locations?.ToList(),
                locationInfo?.ToList(),
                name,
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheSkuCapability"/>. </summary>
        /// <param name="name"> Name of a capability, such as ops/sec. </param>
        /// <param name="value"> Quantity, if the capability is measured by quantity. </param>
        /// <returns> A new <see cref="Models.StorageCacheSkuCapability"/> instance for mocking. </returns>
        public static StorageCacheSkuCapability StorageCacheSkuCapability(string name = null, string value = null)
        {
            return new StorageCacheSkuCapability(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheSkuLocationInfo"/>. </summary>
        /// <param name="location"> Location where this SKU is available. </param>
        /// <param name="zones"> Zones if any. </param>
        /// <returns> A new <see cref="Models.StorageCacheSkuLocationInfo"/> instance for mocking. </returns>
        public static StorageCacheSkuLocationInfo StorageCacheSkuLocationInfo(AzureLocation? location = null, IEnumerable<string> zones = null)
        {
            zones ??= new List<string>();

            return new StorageCacheSkuLocationInfo(location, zones?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheRestriction"/>. </summary>
        /// <param name="restrictionType"> The type of restrictions. In this version, the only possible value for this is location. </param>
        /// <param name="values"> The value of restrictions. If the restriction type is set to location, then this would be the different locations where the SKU is restricted. </param>
        /// <param name="reasonCode"> The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". "QuotaId" is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. "NotAvailableForSubscription" is related to capacity at the datacenter. </param>
        /// <returns> A new <see cref="Models.StorageCacheRestriction"/> instance for mocking. </returns>
        public static StorageCacheRestriction StorageCacheRestriction(string restrictionType = null, IEnumerable<string> values = null, StorageCacheRestrictionReasonCode? reasonCode = null)
        {
            values ??= new List<string>();

            return new StorageCacheRestriction(restrictionType, values?.ToList(), reasonCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheUsageModel"/>. </summary>
        /// <param name="displayDescription"> Localized information describing this usage model. </param>
        /// <param name="modelName"> Non-localized keyword name for this usage model. </param>
        /// <param name="targetType"> The type of Storage Target to which this model is applicable (only nfs3 as of this version). </param>
        /// <returns> A new <see cref="Models.StorageCacheUsageModel"/> instance for mocking. </returns>
        public static StorageCacheUsageModel StorageCacheUsageModel(string displayDescription = null, string modelName = null, string targetType = null)
        {
            return new StorageCacheUsageModel(displayDescription != null ? new StorageCacheUsageModelDisplay(displayDescription, serializedAdditionalRawData: null) : null, modelName, targetType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheUsage"/>. </summary>
        /// <param name="limit"> The limit (quota) for this resource. </param>
        /// <param name="unit"> Unit that the limit and usages are expressed in, such as 'Count'. </param>
        /// <param name="currentValue"> The current usage of this resource. </param>
        /// <param name="name"> Naming information for this resource type. </param>
        /// <returns> A new <see cref="Models.StorageCacheUsage"/> instance for mocking. </returns>
        public static StorageCacheUsage StorageCacheUsage(int? limit = null, string unit = null, int? currentValue = null, StorageCacheUsageName name = null)
        {
            return new StorageCacheUsage(limit, unit, currentValue, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheUsageName"/>. </summary>
        /// <param name="value"> Canonical name for this resource type. </param>
        /// <param name="localizedValue"> Localized name for this resource type. </param>
        /// <returns> A new <see cref="Models.StorageCacheUsageName"/> instance for mocking. </returns>
        public static StorageCacheUsageName StorageCacheUsageName(string value = null, string localizedValue = null)
        {
            return new StorageCacheUsageName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageCache.StorageCacheData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the cache, if configured. </param>
        /// <param name="skuName"> SKU for the cache. </param>
        /// <param name="cacheSizeGB"> The size of this Cache, in GB. </param>
        /// <param name="health"> Health of the cache. </param>
        /// <param name="mountAddresses"> Array of IPv4 addresses that can be used by clients mounting this cache. </param>
        /// <param name="provisioningState"> ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property. </param>
        /// <param name="subnet"> Subnet used for the Cache. </param>
        /// <param name="upgradeStatus"> Upgrade status of the cache. </param>
        /// <param name="upgradeSettings"> Upgrade settings of the cache. </param>
        /// <param name="networkSettings"> Specifies network settings of the cache. </param>
        /// <param name="encryptionSettings"> Specifies encryption settings of the cache. </param>
        /// <param name="securityAccessPolicies"> Specifies security settings of the cache. </param>
        /// <param name="directoryServicesSettings"> Specifies Directory Services settings of the cache. </param>
        /// <param name="zones"> Availability zones for resources. This field should only contain a single element in the array. </param>
        /// <param name="primingJobs"> Specifies the priming jobs defined in the cache. </param>
        /// <param name="spaceAllocation"> Specifies the space allocation percentage for each storage target in the cache. </param>
        /// <returns> A new <see cref="StorageCache.StorageCacheData"/> instance for mocking. </returns>
        public static StorageCacheData StorageCacheData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string skuName = null, int? cacheSizeGB = null, StorageCacheHealth health = null, IEnumerable<IPAddress> mountAddresses = null, StorageCacheProvisioningStateType? provisioningState = null, ResourceIdentifier subnet = null, StorageCacheUpgradeStatus upgradeStatus = null, StorageCacheUpgradeSettings upgradeSettings = null, StorageCacheNetworkSettings networkSettings = null, StorageCacheEncryptionSettings encryptionSettings = null, IEnumerable<NfsAccessPolicy> securityAccessPolicies = null, StorageCacheDirectorySettings directoryServicesSettings = null, IEnumerable<string> zones = null, IEnumerable<PrimingJob> primingJobs = null, IEnumerable<StorageTargetSpaceAllocation> spaceAllocation = null)
        {
            tags ??= new Dictionary<string, string>();
            mountAddresses ??= new List<IPAddress>();
            securityAccessPolicies ??= new List<NfsAccessPolicy>();
            zones ??= new List<string>();
            primingJobs ??= new List<PrimingJob>();
            spaceAllocation ??= new List<StorageTargetSpaceAllocation>();

            return new StorageCacheData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                skuName != null ? new StorageCacheSkuInfo(skuName, serializedAdditionalRawData: null) : null,
                cacheSizeGB,
                health,
                mountAddresses?.ToList(),
                provisioningState,
                subnet,
                upgradeStatus,
                upgradeSettings,
                networkSettings,
                encryptionSettings,
                securityAccessPolicies != null ? new StorageCacheSecuritySettings(securityAccessPolicies?.ToList(), serializedAdditionalRawData: null) : null,
                directoryServicesSettings,
                zones?.ToList(),
                primingJobs?.ToList(),
                spaceAllocation?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheHealth"/>. </summary>
        /// <param name="state"> List of cache health states. Down is when the cluster is not responding.  Degraded is when its functioning but has some alerts. Transitioning when it is creating or deleting. Unknown will be returned in old api versions when a new value is added in future versions. WaitingForKey is when the create is waiting for the system assigned identity to be given access to the encryption key in the encryption settings. </param>
        /// <param name="statusDescription"> Describes explanation of state. </param>
        /// <param name="conditions"> Outstanding conditions that need to be investigated and resolved. </param>
        /// <returns> A new <see cref="Models.StorageCacheHealth"/> instance for mocking. </returns>
        public static StorageCacheHealth StorageCacheHealth(StorageCacheHealthStateType? state = null, string statusDescription = null, IEnumerable<OutstandingCondition> conditions = null)
        {
            conditions ??= new List<OutstandingCondition>();

            return new StorageCacheHealth(state, statusDescription, conditions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OutstandingCondition"/>. </summary>
        /// <param name="timestamp"> The time when the condition was raised. </param>
        /// <param name="message"> The issue requiring attention. </param>
        /// <returns> A new <see cref="Models.OutstandingCondition"/> instance for mocking. </returns>
        public static OutstandingCondition OutstandingCondition(DateTimeOffset? timestamp = null, string message = null)
        {
            return new OutstandingCondition(timestamp, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheUpgradeStatus"/>. </summary>
        /// <param name="currentFirmwareVersion"> Version string of the firmware currently installed on this cache. </param>
        /// <param name="firmwareUpdateStatus"> True if there is a firmware update ready to install on this cache. The firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation. </param>
        /// <param name="firmwareUpdateDeadline"> Time at which the pending firmware update will automatically be installed on the cache. </param>
        /// <param name="lastFirmwareUpdate"> Time of the last successful firmware update. </param>
        /// <param name="pendingFirmwareVersion"> When firmwareUpdateAvailable is true, this field holds the version string for the update. </param>
        /// <returns> A new <see cref="Models.StorageCacheUpgradeStatus"/> instance for mocking. </returns>
        public static StorageCacheUpgradeStatus StorageCacheUpgradeStatus(string currentFirmwareVersion = null, StorageCacheFirmwareStatusType? firmwareUpdateStatus = null, DateTimeOffset? firmwareUpdateDeadline = null, DateTimeOffset? lastFirmwareUpdate = null, string pendingFirmwareVersion = null)
        {
            return new StorageCacheUpgradeStatus(
                currentFirmwareVersion,
                firmwareUpdateStatus,
                firmwareUpdateDeadline,
                lastFirmwareUpdate,
                pendingFirmwareVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheNetworkSettings"/>. </summary>
        /// <param name="mtu"> The IPv4 maximum transmission unit configured for the subnet. </param>
        /// <param name="utilityAddresses"> Array of additional IP addresses used by this cache. </param>
        /// <param name="dnsServers"> DNS servers for the cache to use.  It will be set from the network configuration if no value is provided. </param>
        /// <param name="dnsSearchDomain"> DNS search domain. </param>
        /// <param name="ntpServer"> NTP server IP Address or FQDN for the cache to use. The default is time.windows.com. </param>
        /// <returns> A new <see cref="Models.StorageCacheNetworkSettings"/> instance for mocking. </returns>
        public static StorageCacheNetworkSettings StorageCacheNetworkSettings(int? mtu = null, IEnumerable<IPAddress> utilityAddresses = null, IEnumerable<IPAddress> dnsServers = null, string dnsSearchDomain = null, string ntpServer = null)
        {
            utilityAddresses ??= new List<IPAddress>();
            dnsServers ??= new List<IPAddress>();

            return new StorageCacheNetworkSettings(
                mtu,
                utilityAddresses?.ToList(),
                dnsServers?.ToList(),
                dnsSearchDomain,
                ntpServer,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheActiveDirectorySettings"/>. </summary>
        /// <param name="primaryDnsIPAddress"> Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name. </param>
        /// <param name="secondaryDnsIPAddress"> Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name. </param>
        /// <param name="domainName"> The fully qualified domain name of the Active Directory domain controller. </param>
        /// <param name="domainNetBiosName"> The Active Directory domain's NetBIOS name. </param>
        /// <param name="cacheNetBiosName"> The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z]. </param>
        /// <param name="domainJoined"> True if the HPC Cache is joined to the Active Directory domain. </param>
        /// <param name="credentials"> Active Directory admin credentials used to join the HPC Cache to a domain. </param>
        /// <returns> A new <see cref="Models.StorageCacheActiveDirectorySettings"/> instance for mocking. </returns>
        public static StorageCacheActiveDirectorySettings StorageCacheActiveDirectorySettings(IPAddress primaryDnsIPAddress = null, IPAddress secondaryDnsIPAddress = null, string domainName = null, string domainNetBiosName = null, string cacheNetBiosName = null, DomainJoinedType? domainJoined = null, StorageCacheActiveDirectorySettingsCredentials credentials = null)
        {
            return new StorageCacheActiveDirectorySettings(
                primaryDnsIPAddress,
                secondaryDnsIPAddress,
                domainName,
                domainNetBiosName,
                cacheNetBiosName,
                domainJoined,
                credentials,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageCacheUsernameDownloadSettings"/>. </summary>
        /// <param name="enableExtendedGroups"> Whether or not Extended Groups is enabled. </param>
        /// <param name="usernameSource"> This setting determines how the cache gets username and group names for clients. </param>
        /// <param name="groupFileUri"> The URI of the file containing group information (in /etc/group file format). This field must be populated when 'usernameSource' is set to 'File'. </param>
        /// <param name="userFileUri"> The URI of the file containing user information (in /etc/passwd file format). This field must be populated when 'usernameSource' is set to 'File'. </param>
        /// <param name="ldapServer"> The fully qualified domain name or IP address of the LDAP server to use. </param>
        /// <param name="ldapBaseDN"> The base distinguished name for the LDAP domain. </param>
        /// <param name="encryptLdapConnection"> Whether or not the LDAP connection should be encrypted. </param>
        /// <param name="requireValidCertificate"> Determines if the certificates must be validated by a certificate authority. When true, caCertificateURI must be provided. </param>
        /// <param name="autoDownloadCertificate"> Determines if the certificate should be automatically downloaded. This applies to 'caCertificateURI' only if 'requireValidCertificate' is true. </param>
        /// <param name="caCertificateUri"> The URI of the CA certificate to validate the LDAP secure connection. This field must be populated when 'requireValidCertificate' is set to true. </param>
        /// <param name="usernameDownloaded"> Indicates whether or not the HPC Cache has performed the username download successfully. </param>
        /// <param name="credentials"> When present, these are the credentials for the secure LDAP connection. </param>
        /// <returns> A new <see cref="Models.StorageCacheUsernameDownloadSettings"/> instance for mocking. </returns>
        public static StorageCacheUsernameDownloadSettings StorageCacheUsernameDownloadSettings(bool? enableExtendedGroups = null, StorageCacheUsernameSourceType? usernameSource = null, Uri groupFileUri = null, Uri userFileUri = null, string ldapServer = null, string ldapBaseDN = null, bool? encryptLdapConnection = null, bool? requireValidCertificate = null, bool? autoDownloadCertificate = null, Uri caCertificateUri = null, StorageCacheUsernameDownloadedType? usernameDownloaded = null, StorageCacheUsernameDownloadCredential credentials = null)
        {
            return new StorageCacheUsernameDownloadSettings(
                enableExtendedGroups,
                usernameSource,
                groupFileUri,
                userFileUri,
                ldapServer,
                ldapBaseDN,
                encryptLdapConnection,
                requireValidCertificate,
                autoDownloadCertificate,
                caCertificateUri,
                usernameDownloaded,
                credentials,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrimingJob"/>. </summary>
        /// <param name="primingJobName"> The priming job name. </param>
        /// <param name="primingManifestUri"> The URL for the priming manifest file to download. This file must be readable from the HPC Cache. When the file is in Azure blob storage the URL should include a Shared Access Signature (SAS) granting read permissions on the blob. </param>
        /// <param name="primingJobId"> The unique identifier of the priming job. </param>
        /// <param name="primingJobState"> The state of the priming operation. </param>
        /// <param name="primingJobStatus"> The status code of the priming job. </param>
        /// <param name="primingJobDetails"> The job details or error information if any. </param>
        /// <param name="primingJobPercentComplete"> The current progress of the priming job, as a percentage. </param>
        /// <returns> A new <see cref="Models.PrimingJob"/> instance for mocking. </returns>
        public static PrimingJob PrimingJob(string primingJobName = null, Uri primingManifestUri = null, string primingJobId = null, PrimingJobState? primingJobState = null, string primingJobStatus = null, string primingJobDetails = null, double? primingJobPercentComplete = null)
        {
            return new PrimingJob(
                primingJobName,
                primingManifestUri,
                primingJobId,
                primingJobState,
                primingJobStatus,
                primingJobDetails,
                primingJobPercentComplete,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="StorageCache.StorageTargetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="junctions"> List of cache namespace junctions to target for namespace associations. </param>
        /// <param name="targetType"> Type of the Storage Target. </param>
        /// <param name="provisioningState"> ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property. </param>
        /// <param name="state"> Storage target operational state. </param>
        /// <param name="nfs3"> Properties when targetType is nfs3. </param>
        /// <param name="clfsTarget"> Properties when targetType is clfs. </param>
        /// <param name="unknownAttributes"> Properties when targetType is unknown. </param>
        /// <param name="blobNfs"> Properties when targetType is blobNfs. </param>
        /// <param name="allocationPercentage"> The percentage of cache space allocated for this storage target. </param>
        /// <param name="location"> Region name string. </param>
        /// <returns> A new <see cref="StorageCache.StorageTargetData"/> instance for mocking. </returns>
        public static StorageTargetData StorageTargetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<NamespaceJunction> junctions = null, StorageTargetType? targetType = null, StorageCacheProvisioningStateType? provisioningState = null, StorageTargetOperationalStateType? state = null, Nfs3Target nfs3 = null, ResourceIdentifier clfsTarget = null, IDictionary<string, string> unknownAttributes = null, BlobNfsTarget blobNfs = null, int? allocationPercentage = null, AzureLocation? location = null)
        {
            junctions ??= new List<NamespaceJunction>();
            unknownAttributes ??= new Dictionary<string, string>();

            return new StorageTargetData(
                id,
                name,
                resourceType,
                systemData,
                junctions?.ToList(),
                targetType,
                provisioningState,
                state,
                nfs3,
                clfsTarget != null ? new ClfsTarget(clfsTarget, serializedAdditionalRawData: null) : null,
                unknownAttributes != null ? new UnknownTarget(unknownAttributes, serializedAdditionalRawData: null) : null,
                blobNfs,
                allocationPercentage,
                location,
                serializedAdditionalRawData: null);
        }
    }
}
