// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageCache.Models
{
    /// <summary> Active Directory admin credentials used to join the HPC Cache to a domain. </summary>
    public partial class StorageCacheActiveDirectorySettingsCredentials
    {
        /// <summary> Initializes a new instance of StorageCacheActiveDirectorySettingsCredentials. </summary>
        /// <param name="username"> Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </param>
        /// <param name="password"> Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="username"/> or <paramref name="password"/> is null. </exception>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public StorageCacheActiveDirectorySettingsCredentials(string username, string password)
        {
            Argument.AssertNotNull(username, nameof(username));
            Argument.AssertNotNull(password, nameof(password));

            Username = username;
            Password = password;
        }

        /// <summary> Username of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </summary>
        public string Username { get; set; }
        /// <summary> Plain text password of the Active Directory domain administrator. This value is stored encrypted and not returned on response. </summary>
        public string Password { get; set; }
    }
}
