// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.StorageCache.Models;

namespace Azure.ResourceManager.StorageCache.Samples
{
    public partial class Sample_StorageTargetResource
    {
        // Caches_DnsRefresh
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RefreshDns_CachesDnsRefresh()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_DnsRefresh.json
            // this example is just showing the usage of "StorageTargets_DnsRefresh" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.RefreshDnsAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_StorageTargetsDelete()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Delete.json
            // this example is just showing the usage of "StorageTargets_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc1";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_StorageTargetsGet()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Get.json
            // this example is just showing the usage of "StorageTargets_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc1";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            StorageTargetResource result = await storageTarget.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageTargets_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StorageTargetsCreateOrUpdate()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_CreateOrUpdate.json
            // this example is just showing the usage of "StorageTargets_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc1";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            StorageTargetData data = new StorageTargetData()
            {
                Junctions =
{
new NamespaceJunction()
{
NamespacePath = "/path/on/cache",
TargetPath = "/path/on/exp1",
NfsExport = "exp1",
NfsAccessPolicy = "default",
},new NamespaceJunction()
{
NamespacePath = "/path2/on/cache",
TargetPath = "/path2/on/exp2",
NfsExport = "exp2",
NfsAccessPolicy = "rootSquash",
}
},
                TargetType = StorageTargetType.Nfs3,
                Nfs3 = new Nfs3Target()
                {
                    Target = "10.0.44.44",
                    UsageModel = "READ_ONLY",
                    VerificationDelayInSeconds = 30,
                },
            };
            ArmOperation<StorageTargetResource> lro = await storageTarget.UpdateAsync(WaitUntil.Completed, data);
            StorageTargetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageTargets_CreateOrUpdate_BlobNfs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StorageTargetsCreateOrUpdateBlobNfs()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_CreateOrUpdate_BlobNfs.json
            // this example is just showing the usage of "StorageTargets_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc1";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            StorageTargetData data = new StorageTargetData()
            {
                Junctions =
{
new NamespaceJunction()
{
NamespacePath = "/blobnfs",
}
},
                TargetType = StorageTargetType.BlobNfs,
                BlobNfs = new BlobNfsTarget()
                {
                    Target = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Storage/storageAccounts/blofnfs/blobServices/default/containers/blobnfs"),
                    UsageModel = "READ_WRITE",
                    VerificationDelayInSeconds = 28800,
                    WriteBackDelayInSeconds = 3600,
                },
            };
            ArmOperation<StorageTargetResource> lro = await storageTarget.UpdateAsync(WaitUntil.Completed, data);
            StorageTargetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageTargets_CreateOrUpdate_NoJunctions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StorageTargetsCreateOrUpdateNoJunctions()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_CreateOrUpdate_NoJunctions.json
            // this example is just showing the usage of "StorageTargets_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc1";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            StorageTargetData data = new StorageTargetData()
            {
                TargetType = StorageTargetType.Nfs3,
                Nfs3 = new Nfs3Target()
                {
                    Target = "10.0.44.44",
                    UsageModel = "READ_ONLY",
                    VerificationDelayInSeconds = 30,
                },
            };
            ArmOperation<StorageTargetResource> lro = await storageTarget.UpdateAsync(WaitUntil.Completed, data);
            StorageTargetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTargetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageTargets_Flush
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Flush_StorageTargetsFlush()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Flush.json
            // this example is just showing the usage of "StorageTargets_Flush" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.FlushAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_Suspend
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Suspend_StorageTargetsSuspend()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Suspend.json
            // this example is just showing the usage of "StorageTargets_Suspend" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.SuspendAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_Resume
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resume_StorageTargetsResume()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Resume.json
            // this example is just showing the usage of "StorageTargets_Resume" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.ResumeAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_Invalidate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Invalidate_StorageTargetsInvalidate()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_Invalidate.json
            // this example is just showing the usage of "StorageTargets_Invalidate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.InvalidateAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // StorageTargets_RestoreDefaults
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RestoreDefaults_StorageTargetsRestoreDefaults()
        {
            // Generated from example definition: specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2024-03-01/examples/StorageTargets_RestoreDefaults.json
            // this example is just showing the usage of "StorageTargets_RestoreDefaults" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTargetResource created on azure
            // for more information of creating StorageTargetResource, please refer to the document of StorageTargetResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "scgroup";
            string cacheName = "sc";
            string storageTargetName = "st1";
            ResourceIdentifier storageTargetResourceId = StorageTargetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cacheName, storageTargetName);
            StorageTargetResource storageTarget = client.GetStorageTargetResource(storageTargetResourceId);

            // invoke the operation
            await storageTarget.RestoreDefaultsAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
