// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.StorageActions
{
    /// <summary>
    /// A class representing a collection of <see cref="StorageTaskResource"/> and their operations.
    /// Each <see cref="StorageTaskResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="StorageTaskCollection"/> instance call the GetStorageTasks method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class StorageTaskCollection : ArmCollection, IEnumerable<StorageTaskResource>, IAsyncEnumerable<StorageTaskResource>
    {
        private readonly ClientDiagnostics _storageTaskClientDiagnostics;
        private readonly StorageTasksRestOperations _storageTaskRestClient;

        /// <summary> Initializes a new instance of the <see cref="StorageTaskCollection"/> class for mocking. </summary>
        protected StorageTaskCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="StorageTaskCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal StorageTaskCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _storageTaskClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.StorageActions", StorageTaskResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(StorageTaskResource.ResourceType, out string storageTaskApiVersion);
            _storageTaskRestClient = new StorageTasksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, storageTaskApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Asynchronously creates a new storage task resource with the specified parameters. If a storage task is already created and a subsequent create request is issued with different properties, the storage task properties will be updated. If a storage task is already created and a subsequent create or update request is issued with the exact same set of properties, the request will succeed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="data"> The parameters to create a Storage Task. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<StorageTaskResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string storageTaskName, StorageTaskData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _storageTaskRestClient.CreateAsync(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, data, cancellationToken).ConfigureAwait(false);
                var operation = new StorageActionsArmOperation<StorageTaskResource>(new StorageTaskOperationSource(Client), _storageTaskClientDiagnostics, Pipeline, _storageTaskRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Asynchronously creates a new storage task resource with the specified parameters. If a storage task is already created and a subsequent create request is issued with different properties, the storage task properties will be updated. If a storage task is already created and a subsequent create or update request is issued with the exact same set of properties, the request will succeed.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Create</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="data"> The parameters to create a Storage Task. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<StorageTaskResource> CreateOrUpdate(WaitUntil waitUntil, string storageTaskName, StorageTaskData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _storageTaskRestClient.Create(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, data, cancellationToken);
                var operation = new StorageActionsArmOperation<StorageTaskResource>(new StorageTaskOperationSource(Client), _storageTaskClientDiagnostics, Pipeline, _storageTaskRestClient.CreateCreateRequest(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the storage task properties
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual async Task<Response<StorageTaskResource>> GetAsync(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.Get");
            scope.Start();
            try
            {
                var response = await _storageTaskRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StorageTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the storage task properties
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual Response<StorageTaskResource> Get(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.Get");
            scope.Start();
            try
            {
                var response = _storageTaskRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StorageTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the storage tasks available under the given resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="StorageTaskResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<StorageTaskResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _storageTaskRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _storageTaskRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new StorageTaskResource(Client, StorageTaskData.DeserializeStorageTaskData(e)), _storageTaskClientDiagnostics, Pipeline, "StorageTaskCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all the storage tasks available under the given resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="StorageTaskResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<StorageTaskResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _storageTaskRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _storageTaskRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new StorageTaskResource(Client, StorageTaskData.DeserializeStorageTaskData(e)), _storageTaskClientDiagnostics, Pipeline, "StorageTaskCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.Exists");
            scope.Start();
            try
            {
                var response = await _storageTaskRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual Response<bool> Exists(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.Exists");
            scope.Start();
            try
            {
                var response = _storageTaskRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual async Task<NullableResponse<StorageTaskResource>> GetIfExistsAsync(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _storageTaskRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<StorageTaskResource>(response.GetRawResponse());
                return Response.FromValue(new StorageTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageTaskName"> The name of the storage task within the specified resource group. Storage task names must be between 3 and 18 characters in length and use numbers and lower-case letters only. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="storageTaskName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="storageTaskName"/> is null. </exception>
        public virtual NullableResponse<StorageTaskResource> GetIfExists(string storageTaskName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(storageTaskName, nameof(storageTaskName));

            using var scope = _storageTaskClientDiagnostics.CreateScope("StorageTaskCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _storageTaskRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, storageTaskName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<StorageTaskResource>(response.GetRawResponse());
                return Response.FromValue(new StorageTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<StorageTaskResource> IEnumerable<StorageTaskResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<StorageTaskResource> IAsyncEnumerable<StorageTaskResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
