// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> Represents the overall result of the execution for the run instance. </summary>
    public readonly partial struct StorageTaskRunResult : IEquatable<StorageTaskRunResult>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTaskRunResult"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTaskRunResult(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static StorageTaskRunResult Succeeded { get; } = new StorageTaskRunResult(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageTaskRunResult Failed { get; } = new StorageTaskRunResult(FailedValue);
        /// <summary> Determines if two <see cref="StorageTaskRunResult"/> values are the same. </summary>
        public static bool operator ==(StorageTaskRunResult left, StorageTaskRunResult right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTaskRunResult"/> values are not the same. </summary>
        public static bool operator !=(StorageTaskRunResult left, StorageTaskRunResult right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTaskRunResult"/>. </summary>
        public static implicit operator StorageTaskRunResult(string value) => new StorageTaskRunResult(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTaskRunResult other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTaskRunResult other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
