// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.StorageActions.Models
{
    internal static partial class StorageTaskProvisioningStateExtensions
    {
        public static string ToSerialString(this StorageTaskProvisioningState value) => value switch
        {
            StorageTaskProvisioningState.ValidateSubscriptionQuotaBegin => "ValidateSubscriptionQuotaBegin",
            StorageTaskProvisioningState.ValidateSubscriptionQuotaEnd => "ValidateSubscriptionQuotaEnd",
            StorageTaskProvisioningState.Creating => "Creating",
            StorageTaskProvisioningState.Succeeded => "Succeeded",
            StorageTaskProvisioningState.Deleting => "Deleting",
            StorageTaskProvisioningState.Canceled => "Canceled",
            StorageTaskProvisioningState.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageTaskProvisioningState value.")
        };

        public static StorageTaskProvisioningState ToStorageTaskProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateSubscriptionQuotaBegin")) return StorageTaskProvisioningState.ValidateSubscriptionQuotaBegin;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ValidateSubscriptionQuotaEnd")) return StorageTaskProvisioningState.ValidateSubscriptionQuotaEnd;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return StorageTaskProvisioningState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return StorageTaskProvisioningState.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return StorageTaskProvisioningState.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return StorageTaskProvisioningState.Canceled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return StorageTaskProvisioningState.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown StorageTaskProvisioningState value.");
        }
    }
}
