// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> Properties of the storage task. </summary>
    public partial class StorageTaskProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageTaskProperties"/>. </summary>
        /// <param name="isEnabled"> Storage Task is enabled when set to true and disabled when set to false. </param>
        /// <param name="description"> Text that describes the purpose of the storage task. </param>
        /// <param name="action"> The storage task action that is executed. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="description"/> or <paramref name="action"/> is null. </exception>
        public StorageTaskProperties(bool isEnabled, string description, StorageTaskAction action)
        {
            Argument.AssertNotNull(description, nameof(description));
            Argument.AssertNotNull(action, nameof(action));

            IsEnabled = isEnabled;
            Description = description;
            Action = action;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskProperties"/>. </summary>
        /// <param name="taskVersion"> Storage task version. </param>
        /// <param name="isEnabled"> Storage Task is enabled when set to true and disabled when set to false. </param>
        /// <param name="description"> Text that describes the purpose of the storage task. </param>
        /// <param name="action"> The storage task action that is executed. </param>
        /// <param name="provisioningState"> Represents the provisioning state of the storage task. </param>
        /// <param name="creationTimeInUtc"> The creation date and time of the storage task in UTC. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageTaskProperties(long? taskVersion, bool isEnabled, string description, StorageTaskAction action, StorageTaskProvisioningState? provisioningState, DateTimeOffset? creationTimeInUtc, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskVersion = taskVersion;
            IsEnabled = isEnabled;
            Description = description;
            Action = action;
            ProvisioningState = provisioningState;
            CreationTimeInUtc = creationTimeInUtc;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskProperties"/> for deserialization. </summary>
        internal StorageTaskProperties()
        {
        }

        /// <summary> Storage task version. </summary>
        public long? TaskVersion { get; }
        /// <summary> Storage Task is enabled when set to true and disabled when set to false. </summary>
        public bool IsEnabled { get; set; }
        /// <summary> Text that describes the purpose of the storage task. </summary>
        public string Description { get; set; }
        /// <summary> The storage task action that is executed. </summary>
        public StorageTaskAction Action { get; set; }
        /// <summary> Represents the provisioning state of the storage task. </summary>
        public StorageTaskProvisioningState? ProvisioningState { get; }
        /// <summary> The creation date and time of the storage task in UTC. </summary>
        public DateTimeOffset? CreationTimeInUtc { get; }
    }
}
