// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageActions.Models
{
    public partial class StorageTaskPreviewActionProperties : IUtf8JsonSerializable, IJsonModel<StorageTaskPreviewActionProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageTaskPreviewActionProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageTaskPreviewActionProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTaskPreviewActionProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("container"u8);
            writer.WriteObjectValue(Container, options);
            writer.WritePropertyName("blobs"u8);
            writer.WriteStartArray();
            foreach (var item in Blobs)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("action"u8);
            writer.WriteObjectValue(Action, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageTaskPreviewActionProperties IJsonModel<StorageTaskPreviewActionProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTaskPreviewActionProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageTaskPreviewActionProperties(document.RootElement, options);
        }

        internal static StorageTaskPreviewActionProperties DeserializeStorageTaskPreviewActionProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            StorageTaskPreviewContainerProperties container = default;
            IList<StorageTaskPreviewBlobProperties> blobs = default;
            StorageTaskPreviewActionCondition action = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("container"u8))
                {
                    container = StorageTaskPreviewContainerProperties.DeserializeStorageTaskPreviewContainerProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("blobs"u8))
                {
                    List<StorageTaskPreviewBlobProperties> array = new List<StorageTaskPreviewBlobProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(StorageTaskPreviewBlobProperties.DeserializeStorageTaskPreviewBlobProperties(item, options));
                    }
                    blobs = array;
                    continue;
                }
                if (property.NameEquals("action"u8))
                {
                    action = StorageTaskPreviewActionCondition.DeserializeStorageTaskPreviewActionCondition(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageTaskPreviewActionProperties(container, blobs, action, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageTaskPreviewActionProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageTaskPreviewActionProperties)} does not support writing '{options.Format}' format.");
            }
        }

        StorageTaskPreviewActionProperties IPersistableModel<StorageTaskPreviewActionProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageTaskPreviewActionProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageTaskPreviewActionProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageTaskPreviewActionProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
