// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StorageActions.Models
{
    public partial class StorageTaskPreviewActionCondition : IUtf8JsonSerializable, IJsonModel<StorageTaskPreviewActionCondition>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageTaskPreviewActionCondition>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageTaskPreviewActionCondition>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionCondition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTaskPreviewActionCondition)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("if"u8);
            writer.WriteObjectValue(If, options);
            writer.WritePropertyName("elseBlockExists"u8);
            writer.WriteBooleanValue(ElseBlockExists);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageTaskPreviewActionCondition IJsonModel<StorageTaskPreviewActionCondition>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionCondition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageTaskPreviewActionCondition)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageTaskPreviewActionCondition(document.RootElement, options);
        }

        internal static StorageTaskPreviewActionCondition DeserializeStorageTaskPreviewActionCondition(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            StorageTaskPreviewActionIfCondition @if = default;
            bool elseBlockExists = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("if"u8))
                {
                    @if = StorageTaskPreviewActionIfCondition.DeserializeStorageTaskPreviewActionIfCondition(property.Value, options);
                    continue;
                }
                if (property.NameEquals("elseBlockExists"u8))
                {
                    elseBlockExists = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageTaskPreviewActionCondition(@if, elseBlockExists, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageTaskPreviewActionCondition>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionCondition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageTaskPreviewActionCondition)} does not support writing '{options.Format}' format.");
            }
        }

        StorageTaskPreviewActionCondition IPersistableModel<StorageTaskPreviewActionCondition>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageTaskPreviewActionCondition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageTaskPreviewActionCondition(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageTaskPreviewActionCondition)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageTaskPreviewActionCondition>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
