// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> The if block of storage task operation. </summary>
    public partial class StorageTaskIfCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageTaskIfCondition"/>. </summary>
        /// <param name="condition"> Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators. </param>
        /// <param name="operations"> List of operations to execute when the condition predicate satisfies. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="condition"/> or <paramref name="operations"/> is null. </exception>
        public StorageTaskIfCondition(string condition, IEnumerable<StorageTaskOperationInfo> operations)
        {
            Argument.AssertNotNull(condition, nameof(condition));
            Argument.AssertNotNull(operations, nameof(operations));

            Condition = condition;
            Operations = operations.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskIfCondition"/>. </summary>
        /// <param name="condition"> Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators. </param>
        /// <param name="operations"> List of operations to execute when the condition predicate satisfies. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageTaskIfCondition(string condition, IList<StorageTaskOperationInfo> operations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Condition = condition;
            Operations = operations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskIfCondition"/> for deserialization. </summary>
        internal StorageTaskIfCondition()
        {
        }

        /// <summary> Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators. </summary>
        public string Condition { get; set; }
        /// <summary> List of operations to execute when the condition predicate satisfies. </summary>
        public IList<StorageTaskOperationInfo> Operations { get; }
    }
}
