// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> The storage task action represents conditional statements and operations to be performed on target objects. </summary>
    public partial class StorageTaskAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageTaskAction"/>. </summary>
        /// <param name="if"> The if block of storage task operation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="if"/> is null. </exception>
        public StorageTaskAction(StorageTaskIfCondition @if)
        {
            Argument.AssertNotNull(@if, nameof(@if));

            If = @if;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAction"/>. </summary>
        /// <param name="if"> The if block of storage task operation. </param>
        /// <param name="else"> The else block of storage task operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageTaskAction(StorageTaskIfCondition @if, StorageTaskElseCondition @else, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            If = @if;
            Else = @else;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageTaskAction"/> for deserialization. </summary>
        internal StorageTaskAction()
        {
        }

        /// <summary> The if block of storage task operation. </summary>
        public StorageTaskIfCondition If { get; set; }
        /// <summary> The else block of storage task operation. </summary>
        internal StorageTaskElseCondition Else { get; set; }
        /// <summary> List of operations to execute in the else block. </summary>
        public IList<StorageTaskOperationInfo> ElseOperations
        {
            get => Else is null ? default : Else.Operations;
            set => Else = new StorageTaskElseCondition(value);
        }
    }
}
