// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.StorageActions.Models
{
    /// <summary> Action to be taken when the operation is successful for a object. </summary>
    public readonly partial struct OnSuccessAction : IEquatable<OnSuccessAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OnSuccessAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OnSuccessAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ContinueValue = "continue";

        /// <summary> continue. </summary>
        public static OnSuccessAction Continue { get; } = new OnSuccessAction(ContinueValue);
        /// <summary> Determines if two <see cref="OnSuccessAction"/> values are the same. </summary>
        public static bool operator ==(OnSuccessAction left, OnSuccessAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OnSuccessAction"/> values are not the same. </summary>
        public static bool operator !=(OnSuccessAction left, OnSuccessAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OnSuccessAction"/>. </summary>
        public static implicit operator OnSuccessAction(string value) => new OnSuccessAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OnSuccessAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OnSuccessAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
